/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.BlankTileException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;

public class CircularExtentFilter
extends RequestFilter {
    private static final long serialVersionUID = -8488899568092162423L;

    CircularExtentFilter() {
    }

    @Override
    public void apply(ConveyorTile convTile) throws RequestFilterException {
        long yDist;
        TileLayer tl = convTile.getLayer();
        GridSubset gridSubset = tl.getGridSubset(convTile.getGridSetId());
        int z = (int)convTile.getTileIndex()[2];
        long[] gridCoverage = gridSubset.getCoverage(z);
        long width = gridCoverage[2] - gridCoverage[0];
        long height = gridCoverage[3] - gridCoverage[1];
        long maxRad = 0L;
        maxRad = width > height ? width / 4L + 1L : height / 4L + 1L;
        long midX = gridCoverage[0] + width / 2L;
        long midY = gridCoverage[1] + height / 2L;
        long xDist = midX - convTile.getTileIndex()[0];
        long rad = Math.round(Math.sqrt(xDist * xDist + (yDist = midY - convTile.getTileIndex()[1]) * yDist));
        if (rad > maxRad) {
            throw new BlankTileException(this);
        }
    }

    @Override
    public void initialize(TileLayer layer) throws GeoWebCacheException {
    }

    @Override
    public void update(TileLayer layer, String gridSetId, int zoomStart, int zoomStop) throws GeoWebCacheException {
    }

    @Override
    public void update(byte[] filterData, TileLayer layer, String gridSetId, int z) throws GeoWebCacheException {
    }

    @Override
    public boolean update(TileLayer layer, String gridSetId) {
        return false;
    }
}

