/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridCoverage;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.grid.TileDimensionsMismatchException;
import org.geowebcache.util.ServletUtils;

public class GridSubset {
    private final GridSet gridSet;
    private final Map<Integer, GridCoverage> gridCoverageLevels;
    private final boolean fullGridSetCoverage;
    private final BoundingBox subSetExtent;
    private final Integer minCachedZoom;
    private final Integer maxCachedZoom;

    protected GridSubset(GridSet gridSet, Map<Integer, GridCoverage> coverages, BoundingBox originalExtent, boolean fullCoverage) {
        this(gridSet, coverages, originalExtent, fullCoverage, null, null);
    }

    public GridSubset(GridSet gridSet, Map<Integer, GridCoverage> coverages, BoundingBox originalExtent, boolean fullCoverage, Integer minCachedZoom, Integer maxCachedZoom) {
        this.gridSet = gridSet;
        this.gridCoverageLevels = coverages;
        this.subSetExtent = originalExtent;
        this.fullGridSetCoverage = fullCoverage;
        this.minCachedZoom = minCachedZoom;
        this.maxCachedZoom = maxCachedZoom;
    }

    public GridSubset(GridSubset subSet) {
        this(subSet.gridSet, new TreeMap<Integer, GridCoverage>(subSet.gridCoverageLevels), subSet.subSetExtent, subSet.fullGridSetCoverage, subSet.minCachedZoom, subSet.maxCachedZoom);
    }

    public BoundingBox boundsFromIndex(long[] tileIndex) {
        return this.getGridSet().boundsFromIndex(tileIndex);
    }

    public BoundingBox boundsFromRectangle(long[] rectangleExtent) {
        return this.gridSet.boundsFromRectangle(rectangleExtent);
    }

    public long[] closestIndex(BoundingBox tileBounds) throws GridMismatchException {
        return this.gridSet.closestIndex(tileBounds);
    }

    public long[] closestRectangle(BoundingBox rectangleBounds) {
        return this.gridSet.closestRectangle(rectangleBounds);
    }

    public boolean covers(long[] index) {
        int level = (int)index[2];
        long[] coverage = this.getCoverage(level);
        if (coverage == null) {
            return false;
        }
        return index[0] >= coverage[0] && index[0] <= coverage[2] && index[1] >= coverage[1] && index[1] <= coverage[3];
    }

    public void checkCoverage(long[] index) throws OutsideCoverageException {
        if (this.covers(index)) {
            return;
        }
        if (index[2] < (long)this.getZoomStart() || index[2] > (long)this.getZoomStop()) {
            throw new OutsideCoverageException(index, this.getZoomStart(), this.getZoomStop());
        }
        long[] coverage = this.getCoverage((int)index[2]);
        throw new OutsideCoverageException(index, coverage);
    }

    public void checkTileDimensions(int width, int height) throws TileDimensionsMismatchException {
        if (width != this.gridSet.getTileWidth() || height != this.gridSet.getTileHeight()) {
            throw new TileDimensionsMismatchException(width, height, this.gridSet.getTileWidth(), this.gridSet.getTileWidth());
        }
    }

    public long[][] expandToMetaFactors(long[][] coverages, int[] metaFactors) {
        long[][] ret;
        for (long[] cov : ret = ServletUtils.arrayDeepCopy(coverages)) {
            int z = (int)cov[4];
            Grid grid = this.gridSet.getGrid(z);
            long numTilesWide = grid.getNumTilesWide();
            long numTilesHigh = grid.getNumTilesHigh();
            cov[0] = cov[0] - cov[0] % (long)metaFactors[0];
            cov[1] = cov[1] - cov[1] % (long)metaFactors[1];
            cov[2] = cov[2] - cov[2] % (long)metaFactors[0] + (long)(metaFactors[0] - 1);
            if (cov[2] > numTilesWide) {
                cov[2] = numTilesWide;
            }
            cov[3] = cov[3] - cov[3] % (long)metaFactors[1] + (long)(metaFactors[1] - 1);
            if (cov[3] <= numTilesHigh) continue;
            cov[3] = numTilesHigh;
        }
        return ret;
    }

    public long[] getCoverage(int level) {
        GridCoverage gridCoverage = this.gridCoverageLevels.get(level);
        if (gridCoverage == null) {
            return null;
        }
        long[] coverage = (long[])gridCoverage.coverage.clone();
        return coverage;
    }

    public long[][] getCoverages() {
        long[][] ret = new long[this.gridCoverageLevels.size()][5];
        int zoomStart = this.getZoomStart();
        int zoomStop = this.getZoomStop();
        int level = zoomStart;
        int i = 0;
        while (level <= zoomStop) {
            long[] cov = this.getCoverage(level);
            ret[i] = cov;
            ++level;
            ++i;
        }
        return ret;
    }

    public double getDotsPerInch() {
        return 0.0254 / this.gridSet.getPixelSize();
    }

    public BoundingBox getCoverageBounds(int level) {
        long[] coverage = this.getCoverage(level);
        return this.gridSet.boundsFromRectangle(coverage);
    }

    public long[] getCoverageBestFit() {
        int zoomStop;
        int level;
        long[] cov = null;
        int zoomStart = this.getZoomStart();
        for (level = zoomStop = this.getZoomStop(); level > zoomStart && ((cov = this.getCoverage(level))[0] != cov[2] || cov[1] != cov[3]); --level) {
        }
        cov = this.getCoverage(level);
        return cov;
    }

    public BoundingBox getCoverageBestFitBounds() {
        return this.boundsFromRectangle(this.getCoverageBestFit());
    }

    public long[] getCoverageIntersection(long[] reqRectangle) {
        int level = (int)reqRectangle[4];
        GridCoverage gridCov = this.gridCoverageLevels.get(level);
        return gridCov.getIntersection(reqRectangle);
    }

    public long[][] getCoverageIntersections(BoundingBox reqBounds) {
        int zoomStart = this.getZoomStart();
        int zoomStop = this.getZoomStop();
        long[][] ret = new long[1 + zoomStop - zoomStart][5];
        for (int level = zoomStart; level <= zoomStop; ++level) {
            ret[level - zoomStart] = this.getCoverageIntersection(level, reqBounds);
        }
        return ret;
    }

    public long[] getCoverageIntersection(int level, BoundingBox reqBounds) {
        long[] reqRectangle = this.gridSet.closestRectangle(level, reqBounds);
        GridCoverage gridCoverage = this.gridCoverageLevels.get(level);
        return gridCoverage.getIntersection(reqRectangle);
    }

    public long getGridIndex(String gridId) {
        int zoomStart = this.getZoomStart();
        int zoomStop = this.getZoomStop();
        for (int index = zoomStart; index <= zoomStop; ++index) {
            if (!this.gridSet.getGrid(index).getName().equals(gridId)) continue;
            return index;
        }
        return -1L;
    }

    public String[] getGridNames() {
        ArrayList<String> ret = new ArrayList<String>(this.gridCoverageLevels.size());
        int zoomStart = this.getZoomStart();
        int zoomStop = this.getZoomStop();
        for (int i = zoomStart; i <= zoomStop; ++i) {
            ret.add(this.gridSet.getGrid(i).getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public GridSet getGridSet() {
        return this.gridSet;
    }

    public BoundingBox getGridSetBounds() {
        return this.gridSet.getBounds();
    }

    public long getNumTilesWide(int zoomLevel) {
        return this.gridSet.getGrid(zoomLevel).getNumTilesWide();
    }

    public long getNumTilesHigh(int zoomLevel) {
        return this.gridSet.getGrid(zoomLevel).getNumTilesHigh();
    }

    public String getName() {
        return this.gridSet.getName();
    }

    public BoundingBox getOriginalExtent() {
        if (this.subSetExtent == null) {
            return this.gridSet.getOriginalExtent();
        }
        return this.subSetExtent;
    }

    public double[] getResolutions() {
        double[] ret = new double[this.gridCoverageLevels.size()];
        int zoomStart = this.getZoomStart();
        int zoomStop = this.getZoomStop();
        int z = zoomStart;
        int i = 0;
        while (z <= zoomStop) {
            Grid grid = this.gridSet.getGrid(z);
            ret[i] = grid.getResolution();
            ++z;
            ++i;
        }
        return ret;
    }

    public long[][] getSubGrid(long[] gridLoc) throws GeoWebCacheException {
        int firstLevel = this.getZoomStart();
        int zoomStop = this.getZoomStop();
        int idx = (int)gridLoc[2];
        long[][] ret = new long[][]{{-1L, -1L, -1L}, {-1L, -1L, -1L}, {-1L, -1L, -1L}, {-1L, -1L, -1L}};
        if (idx - firstLevel + 1 <= zoomStop) {
            double resolutionCheck = this.gridSet.getGrid(idx).getResolution() / 2.0 - this.gridSet.getGrid(idx + 1).getResolution();
            if (Math.abs(resolutionCheck) > this.gridSet.getGrid(idx + 1).getResolution() * 0.025) {
                throw new GeoWebCacheException("The resolution is not decreasing by a factor of two for " + this.getName());
            }
            long[] coverage = this.getCoverage(idx + 1);
            long baseX = gridLoc[0] * 2L;
            long baseY = gridLoc[1] * 2L;
            long baseZ = (long)idx + 1L;
            long[] xOffset = new long[]{0L, 1L, 0L, 1L};
            long[] yOffset = new long[]{0L, 0L, 1L, 1L};
            for (int i = 0; i < 4; ++i) {
                if (baseX + xOffset[i] < coverage[0] || baseX + xOffset[i] > coverage[2] || baseY + yOffset[i] < coverage[1] || baseY + yOffset[i] > coverage[3]) continue;
                ret[i][0] = baseX + xOffset[i];
                ret[i][1] = baseY + yOffset[i];
                ret[i][2] = baseZ;
            }
        }
        return ret;
    }

    public boolean getScaleWarning() {
        return this.gridSet.isScaleWarning();
    }

    public SRS getSRS() {
        return this.gridSet.getSrs();
    }

    public int getTileHeight() {
        return this.gridSet.getTileHeight();
    }

    public int getTileWidth() {
        return this.gridSet.getTileWidth();
    }

    public long[][] getWMTSCoverages() {
        int zoomStart;
        long[][] ret = new long[this.gridCoverageLevels.size()][4];
        int zoomStop = this.getZoomStop();
        for (int i = zoomStart = this.getZoomStart(); i <= zoomStop; ++i) {
            Grid grid = this.gridSet.getGrid(i);
            long[] coverage = this.getCoverage(i);
            long bottomRow = grid.getNumTilesHigh() - 1L;
            long[] cur = new long[]{coverage[0], bottomRow - coverage[3], coverage[2], bottomRow - coverage[1]};
            ret[i - zoomStart] = cur;
        }
        return ret;
    }

    public int getZoomStart() {
        Integer firstLevel = Collections.min(this.gridCoverageLevels.keySet());
        return firstLevel;
    }

    public int getZoomStop() {
        Integer maxLevel = Collections.max(this.gridCoverageLevels.keySet());
        return maxLevel;
    }

    public Integer getMinCachedZoom() {
        return this.minCachedZoom;
    }

    public Integer getMaxCachedZoom() {
        return this.maxCachedZoom;
    }

    public boolean fullGridSetCoverage() {
        return this.fullGridSetCoverage;
    }

    public boolean shouldCacheAtZoom(long zoom) {
        boolean shouldCache = true;
        if (this.minCachedZoom != null) {
            boolean bl = shouldCache = zoom >= (long)this.minCachedZoom.intValue();
        }
        if (shouldCache && this.maxCachedZoom != null) {
            shouldCache = zoom <= (long)this.maxCachedZoom.intValue();
        }
        return shouldCache;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

