/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Info;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.TileLayerListener;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.util.ServletUtils;

public abstract class TileLayer
implements Info {
    private static Logger log = Logging.getLogger((String)TileLayer.class.getName());
    protected static final ThreadLocal<ByteArrayResource> WMS_BUFFER = new ThreadLocal();
    protected static final ThreadLocal<ByteArrayResource> WMS_BUFFER2 = new ThreadLocal();
    protected transient Map<String, String> defaultParameterFilterValues;

    public abstract void addLayerListener(TileLayerListener var1);

    public abstract boolean removeLayerListener(TileLayerListener var1);

    public abstract String getId();

    @Nullable
    public abstract String getBlobStoreId();

    public abstract void setBlobStoreId(@Nullable String var1);

    @Override
    public abstract String getName();

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract boolean isAdvertised();

    public abstract void setAdvertised(boolean var1);

    public abstract boolean isTransientLayer();

    public abstract void setTransientLayer(boolean var1);

    public abstract LayerMetaInformation getMetaInformation();

    public List<MetadataURL> getMetadataURLs() {
        return null;
    }

    public abstract Set<String> getGridSubsets();

    public abstract List<UpdateSourceDefinition> getUpdateSources();

    public abstract boolean useETags();

    public abstract ConveyorTile getTile(ConveyorTile var1) throws GeoWebCacheException, IOException, OutsideCoverageException;

    public abstract ConveyorTile getNoncachedTile(ConveyorTile var1) throws GeoWebCacheException;

    public abstract void seedTile(ConveyorTile var1, boolean var2) throws GeoWebCacheException, IOException;

    public abstract ConveyorTile doNonMetatilingRequest(ConveyorTile var1) throws GeoWebCacheException;

    public abstract List<FormatModifier> getFormatModifiers();

    public abstract void setFormatModifiers(List<FormatModifier> var1);

    public abstract String getStyles();

    public Map<String, LegendInfo> getLayerLegendsInfo() {
        return Collections.emptyMap();
    }

    public abstract int[] getMetaTilingFactors();

    public abstract Boolean isCacheBypassAllowed();

    public abstract void setCacheBypassAllowed(boolean var1);

    public abstract boolean isQueryable();

    public abstract Integer getBackendTimeout();

    public abstract void setBackendTimeout(int var1);

    public abstract List<MimeType> getMimeTypes();

    public abstract List<MimeType> getInfoMimeTypes();

    public abstract int getExpireClients(int var1);

    public abstract int getExpireCache(int var1);

    public abstract List<ParameterFilter> getParameterFilters();

    public abstract List<RequestFilter> getRequestFilters();

    public abstract boolean initialize(GridSetBroker var1);

    public GridSubset getGridSubsetForSRS(SRS srs) {
        for (String gridSet : this.getGridSubsets()) {
            GridSubset gridSubset = this.getGridSubset(gridSet);
            SRS gridSetSRS = gridSubset.getSRS();
            if (!gridSetSRS.equals(srs)) continue;
            return gridSubset;
        }
        return null;
    }

    public List<GridSubset> getGridSubsetsForSRS(SRS srs) {
        List<GridSubset> matches = Collections.emptyList();
        for (String gridSet : this.getGridSubsets()) {
            GridSubset gridSubset = this.getGridSubset(gridSet);
            SRS gridSetSRS = gridSubset.getSRS();
            if (!gridSetSRS.equals(srs)) continue;
            if (matches.isEmpty()) {
                matches = new ArrayList<GridSubset>(2);
            }
            matches.add(gridSubset);
        }
        return matches.isEmpty() ? matches : Collections.unmodifiableList(matches);
    }

    public boolean supportsFormat(String strFormat) throws GeoWebCacheException {
        if (strFormat == null) {
            return true;
        }
        for (MimeType mime : this.getMimeTypes()) {
            if (!strFormat.equalsIgnoreCase(mime.getFormat())) continue;
            return true;
        }
        throw new GeoWebCacheException("Format " + strFormat + " is not supported by " + this.getName());
    }

    public Resource getFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        throw new GeoWebCacheException("GetFeatureInfo is not supported by this layer (" + this.getName() + ")");
    }

    public double[] getResolutions(String gridSetId) throws GeoWebCacheException {
        return this.getGridSubset(gridSetId).getResolutions();
    }

    public FormatModifier getFormatModifier(MimeType responseFormat) {
        List<FormatModifier> formatModifiers = this.getFormatModifiers();
        if (formatModifiers == null || formatModifiers.isEmpty()) {
            return null;
        }
        for (FormatModifier mod : formatModifiers) {
            if (!Objects.equals(mod.getResponseFormat(), responseFormat)) continue;
            return mod;
        }
        return null;
    }

    public MimeType getDefaultMimeType() {
        return this.getMimeTypes().get(0);
    }

    public long[] indexFromBounds(String gridSetId, BoundingBox tileBounds) throws GridMismatchException {
        return this.getGridSubset(gridSetId).closestIndex(tileBounds);
    }

    public BoundingBox boundsFromIndex(String gridSetId, long[] gridLoc) {
        return this.getGridSubset(gridSetId).boundsFromIndex(gridLoc);
    }

    public void setExpirationHeader(HttpServletResponse response, int zoomLevel) {
        int expireValue = this.getExpireClients(zoomLevel);
        if (expireValue == 0) {
            return;
        }
        if (expireValue > 0) {
            response.setHeader("Cache-Control", "max-age=" + expireValue + ", must-revalidate");
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(expireValue));
        } else if (expireValue == -2) {
            long oneYear = 31536000L;
            response.setHeader("Cache-Control", "max-age=" + oneYear);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader((int)oneYear));
        } else if (expireValue == -1) {
            response.setHeader("Cache-Control", "no-cache");
        } else if (expireValue == -4) {
            int seconds = 3600;
            response.setHeader("geowebcache-error", "No real CacheControl information available");
            response.setHeader("Cache-Control", "max-age=" + seconds);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(seconds));
        }
    }

    public void applyRequestFilters(ConveyorTile convTile) throws RequestFilterException {
        List<RequestFilter> requestFilters = this.getRequestFilters();
        if (requestFilters == null) {
            return;
        }
        for (RequestFilter filter : requestFilters) {
            filter.apply(convTile);
        }
    }

    public Map<String, String> getDefaultParameterFilters() {
        if (this.defaultParameterFilterValues == null) {
            List<ParameterFilter> parameterFilters = this.getParameterFilters();
            if (parameterFilters == null || parameterFilters.isEmpty()) {
                this.defaultParameterFilterValues = Collections.emptyMap();
            } else {
                HashMap<String, String> defaults = new HashMap<String, String>();
                for (ParameterFilter parameterFilter : parameterFilters) {
                    String key = parameterFilter.getKey().toUpperCase();
                    String defaultValue = TileLayer.decodeDimensionValue(parameterFilter.getDefaultValue());
                    defaults.put(key, defaultValue);
                }
                this.defaultParameterFilterValues = Collections.unmodifiableMap(defaults);
            }
        }
        return this.defaultParameterFilterValues;
    }

    public Map<String, String> getModifiableParameters(Map<String, ?> map, String encoding) throws GeoWebCacheException {
        List<ParameterFilter> parameterFilters = this.getParameterFilters();
        if (parameterFilters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fullParameters = new HashMap<String, String>();
        String[] keys = (String[])parameterFilters.stream().map(ParameterFilter::getKey).toArray(String[]::new);
        Map<String, String> requestValues = ServletUtils.selectedStringsFromMap(map, encoding, keys);
        Map<String, String> defaultValues = this.getDefaultParameterFilters();
        for (ParameterFilter parameterFilter : parameterFilters) {
            String key = parameterFilter.getKey().toUpperCase();
            String value = requestValues.get(key);
            value = TileLayer.decodeDimensionValue(value);
            String defaultValue = defaultValues.get(key);
            if (value == null || value.length() == 0 || defaultValue != null && defaultValue.equals(value)) {
                fullParameters.put(key, defaultValue);
                continue;
            }
            String appliedValue = parameterFilter.apply(value);
            fullParameters.put(key, appliedValue);
        }
        if (defaultValues.equals(fullParameters)) {
            return Collections.emptyMap();
        }
        return fullParameters;
    }

    protected static String decodeDimensionValue(String value) {
        if (value != null && value.startsWith("_")) {
            if (value.equals("_null")) {
                return null;
            }
            if (value.equals("_empty")) {
                return "";
            }
            return value;
        }
        return value;
    }

    public static String encodeDimensionValue(String value) {
        if (value == null) {
            return "_null";
        }
        if (value.length() == 0) {
            return "_empty";
        }
        return value;
    }

    public abstract GridSubset getGridSubset(String var1);

    public abstract GridSubset removeGridSubset(String var1);

    public abstract void addGridSubset(GridSubset var1);

    protected ByteArrayResource getImageBuffer(ThreadLocal<ByteArrayResource> tl) {
        ByteArrayResource buffer = tl.get();
        if (buffer == null) {
            buffer = new ByteArrayResource(16384);
            tl.set(buffer);
        }
        buffer.truncate();
        return buffer;
    }

    protected void saveTiles(MetaTile metaTile, ConveyorTile tileProto, long requestTime) throws GeoWebCacheException {
        long[][] gridPositions = metaTile.getTilesGridPositions();
        long[] gridLoc = tileProto.getTileIndex();
        GridSubset gridSubset = this.getGridSubset(tileProto.getGridSetId());
        int zoomLevel = (int)gridLoc[2];
        boolean store = this.getExpireCache(zoomLevel) != -1;
        for (int i = 0; i < gridPositions.length; ++i) {
            boolean encode;
            ByteArrayResource resource;
            long[] gridPos = gridPositions[i];
            if (Arrays.equals(gridLoc, gridPos)) {
                resource = this.getImageBuffer(WMS_BUFFER2);
                tileProto.setBlob(resource);
                encode = true;
            } else {
                resource = this.getImageBuffer(WMS_BUFFER);
                encode = store;
            }
            if (!encode || !gridSubset.covers(gridPos)) continue;
            try {
                boolean completed = metaTile.writeTileToStream(i, resource);
                if (!completed) {
                    log.log(Level.SEVERE, "metaTile.writeTileToStream returned false, no tiles saved");
                }
                if (!store) continue;
                long[] idx = new long[]{gridPos[0], gridPos[1], gridPos[2]};
                TileObject tile = TileObject.createCompleteTileObject(this.getName(), idx, tileProto.getGridSetId(), tileProto.getMimeType().getFormat(), tileProto.getParameters(), resource);
                tile.setCreated(requestTime);
                try {
                    if (tileProto.isMetaTileCacheOnly()) {
                        tileProto.getStorageBroker().putTransient(tile);
                    } else {
                        tileProto.getStorageBroker().put(tile);
                    }
                    tileProto.getStorageObject().setCreated(tile.getCreated());
                    continue;
                }
                catch (StorageException e) {
                    throw new GeoWebCacheException(e);
                }
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Unable to write image tile to ByteArrayOutputStream", ioe);
            }
        }
    }
}

