/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ConfigurationAggregator;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcherFilter;
import org.geowebcache.util.CompositeIterable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class TileLayerDispatcher
implements DisposableBean,
InitializingBean,
ApplicationContextAware,
ConfigurationAggregator<TileLayerConfiguration> {
    TileLayerDispatcherFilter tileLayerDispatcherFilter;
    private List<TileLayerConfiguration> configs;
    private GridSetBroker gridSetBroker;
    private ServiceInformation serviceInformation;
    private ApplicationContext applicationContext;

    public TileLayerDispatcher(GridSetBroker gridSetBroker, List<TileLayerConfiguration> configs, TileLayerDispatcherFilter tileLayerDispatcherFilter) {
        this.gridSetBroker = gridSetBroker;
        this.configs = configs == null ? new ArrayList() : configs;
        this.tileLayerDispatcherFilter = tileLayerDispatcherFilter;
    }

    public TileLayerDispatcher(GridSetBroker gridSetBroker, TileLayerDispatcherFilter tileLayerDispatcherFilter) {
        this.gridSetBroker = gridSetBroker;
        this.tileLayerDispatcherFilter = tileLayerDispatcherFilter;
    }

    public boolean layerExists(String layerName) {
        for (TileLayerConfiguration configuration : this.configs) {
            Optional<TileLayer> layer = configuration.getLayer(layerName);
            if (!layer.isPresent()) continue;
            return true;
        }
        return false;
    }

    public TileLayer getTileLayer(String layerName) throws GeoWebCacheException {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName is null");
        for (TileLayerConfiguration configuration : this.configs) {
            Optional<TileLayer> layer = configuration.getLayer(layerName);
            if (!layer.isPresent()) continue;
            return layer.get();
        }
        throw new GeoWebCacheException("Thread " + Thread.currentThread().getName() + " Unknown layer " + layerName + ". Check the logfiles, it may not have loaded properly.");
    }

    public int getLayerCount() {
        int count = 0;
        for (TileLayerConfiguration configuration : this.configs) {
            count += configuration.getLayerCount();
        }
        return count;
    }

    public Set<String> getLayerNames() {
        HashSet<String> names = new HashSet<String>();
        for (TileLayerConfiguration configuration : this.configs) {
            names.addAll(configuration.getLayerNames());
        }
        return names;
    }

    public Iterable<TileLayer> getLayerList() {
        ArrayList perConfigLayers = new ArrayList(this.configs.size());
        for (TileLayerConfiguration config : this.configs) {
            perConfigLayers.add(config.getLayers());
        }
        CompositeIterable<TileLayer> result = new CompositeIterable<TileLayer>(perConfigLayers);
        return result;
    }

    public Iterable<TileLayer> getLayerListFiltered() {
        Iterable result = this.getLayerList();
        if (this.tileLayerDispatcherFilter != null) {
            result = Iterables.filter(result, x -> !this.tileLayerDispatcherFilter.exclude((TileLayer)x));
        }
        return result;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public void setServiceInformation(ServiceInformation serviceInformation) {
        this.serviceInformation = serviceInformation;
    }

    public void destroy() throws Exception {
    }

    public synchronized void removeLayer(String layerName) throws IllegalArgumentException {
        for (TileLayerConfiguration config : this.configs) {
            if (!config.containsLayer(layerName)) continue;
            config.removeLayer(layerName);
            return;
        }
        throw new NoSuchElementException("No configuration found containing layer " + layerName);
    }

    public synchronized void addLayer(TileLayer tl) throws IllegalArgumentException {
        for (TileLayerConfiguration c : this.configs) {
            if (!c.canSave(tl)) continue;
            c.addLayer(tl);
            return;
        }
        throw new IllegalArgumentException("No configuration found capable of saving " + String.valueOf(tl));
    }

    public synchronized void rename(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException {
        TileLayerConfiguration config = this.getConfiguration(oldName);
        config.renameLayer(oldName, newName);
    }

    public synchronized void modify(TileLayer tl) throws IllegalArgumentException {
        TileLayerConfiguration config = this.getConfiguration(tl);
        config.modifyLayer(tl);
    }

    public TileLayerConfiguration getConfiguration(TileLayer tl) throws IllegalArgumentException {
        Assert.notNull((Object)tl, (String)"layer is null");
        return this.getConfiguration(tl.getName());
    }

    public TileLayerConfiguration getConfiguration(String tileLayerName) throws IllegalArgumentException {
        Assert.notNull((Object)tileLayerName, (String)"tileLayerName is null");
        for (TileLayerConfiguration c : this.configs) {
            if (!c.containsLayer(tileLayerName)) continue;
            return c;
        }
        throw new IllegalArgumentException("No configuration found containing layer " + tileLayerName);
    }

    public synchronized void addGridSet(GridSet gridSet) throws IllegalArgumentException, IOException {
        if (null != this.gridSetBroker.get(gridSet.getName())) {
            throw new IllegalArgumentException("GridSet " + gridSet.getName() + " already exists");
        }
        this.saveGridSet(gridSet);
    }

    private void saveGridSet(GridSet gridSet) throws IOException {
        this.gridSetBroker.addGridSet(gridSet);
    }

    public synchronized void removeGridSet(String gridsetToRemove) {
        if (StreamSupport.stream(this.getLayerList().spliterator(), true).anyMatch(g -> Objects.nonNull(g.getGridSubset(gridsetToRemove)))) {
            throw new IllegalStateException("Can not remove gridset " + gridsetToRemove + " as it is used by layers");
        }
        this.gridSetBroker.removeGridSet(gridsetToRemove);
    }

    public synchronized void removeGridSetRecursive(String gridsetToRemove) {
        ArrayList<TileLayer> deletedLayers = new ArrayList<TileLayer>();
        try {
            for (TileLayer tl : this.getLayerList()) {
                if (!Objects.nonNull(tl.getGridSubset(gridsetToRemove))) continue;
                this.removeLayer(tl.getName());
                deletedLayers.add(tl);
            }
        }
        catch (NoSuchElementException e) {
            IllegalStateException wrappedException = new IllegalStateException("Layer was found referencing gridset but was missing during recursive delete", e);
            try {
                deletedLayers.forEach(this::addLayer);
            }
            catch (RuntimeException exceptionOnRestore) {
                wrappedException.addSuppressed(exceptionOnRestore);
            }
            throw wrappedException;
        }
        try {
            this.gridSetBroker.removeGridSet(gridsetToRemove);
        }
        catch (RuntimeException exceptionOnRestore) {
            try {
                deletedLayers.forEach(this::addLayer);
            }
            catch (RuntimeException ex) {
                exceptionOnRestore.addSuppressed(ex);
            }
            throw exceptionOnRestore;
        }
    }

    @Override
    public <T extends TileLayerConfiguration> List<? extends T> getConfigurations(Class<T> clazz) {
        if (clazz == TileLayerConfiguration.class) {
            return Collections.unmodifiableList(this.configs);
        }
        return this.configs.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        this.configs = GeoWebCacheExtensions.configurations(TileLayerConfiguration.class, this.applicationContext);
        Map config = this.applicationContext.getBeansOfType(BaseConfiguration.class);
        if (config != null && !config.isEmpty()) {
            for (Map.Entry e : config.entrySet()) {
                if (!ServerConfiguration.class.isAssignableFrom(((BaseConfiguration)e.getValue()).getClass())) continue;
                this.setServiceInformation(((ServerConfiguration)e.getValue()).getServiceInformation());
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationContext != null) {
            throw new IllegalStateException("Application context has already been set");
        }
        Objects.requireNonNull(applicationContext);
        this.applicationContext = applicationContext;
    }

    @Deprecated
    public void reInit() {
        GeoWebCacheExtensions.reinitialize(this.applicationContext);
    }
}

