/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.util.Map;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;

public class WMSMetaTile
extends MetaTile {
    protected WMSLayer wmsLayer = null;
    protected Map<String, String> fullParameters;

    protected WMSMetaTile(WMSLayer layer, GridSubset gridSubset, MimeType responseFormat, FormatModifier formatModifier, long[] tileGridPosition, int metaX, int metaY, Map<String, String> fullParameters) {
        super(gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY, layer == null ? null : layer.gutter);
        this.wmsLayer = layer;
        this.fullParameters = fullParameters;
    }

    protected Map<String, String> getWMSParams() throws GeoWebCacheException {
        String format;
        Map<String, String> params = this.wmsLayer.getWMSRequestTemplate(this.getResponseFormat(), WMSLayer.RequestType.MAP);
        if (this.formatModifier == null) {
            format = this.responseFormat.getFormat();
        } else {
            MimeType requestFormat = this.formatModifier.getRequestFormat();
            format = requestFormat.getFormat();
        }
        params.put("FORMAT", format);
        params.put("SRS", this.wmsLayer.backendSRSOverride(this.gridSubset.getSRS()));
        params.put("WIDTH", String.valueOf(this.getMetaTileWidth()));
        params.put("HEIGHT", String.valueOf(this.getMetaTileHeight()));
        params.put("BBOX", String.valueOf(this.getMetaTileBounds()));
        params.putAll(this.fullParameters);
        return params;
    }

    public int[] getGutter() {
        return (int[])this.gutter.clone();
    }

    protected WMSLayer getLayer() {
        return this.wmsLayer;
    }
}

