/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.locks;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.locks.LockProvider;

public class MemoryLockProvider
implements LockProvider {
    private static final Logger LOGGER = Logging.getLogger((String)MemoryLockProvider.class.getName());
    ConcurrentHashMap<String, LockAndCounter> lockAndCounters = new ConcurrentHashMap();

    @Override
    public LockProvider.Lock getLock(final String lockKey) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Acquiring lock key " + lockKey);
        }
        LockAndCounter lockAndCounter = this.lockAndCounters.compute(lockKey, (key, internalLockAndCounter) -> {
            if (internalLockAndCounter == null) {
                internalLockAndCounter = new LockAndCounter();
            }
            internalLockAndCounter.counter.incrementAndGet();
            return internalLockAndCounter;
        });
        lockAndCounter.lock.lock();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Acquired lock key " + lockKey);
        }
        return new LockProvider.Lock(){
            boolean released = false;

            @Override
            public void release() {
                if (!this.released) {
                    this.released = true;
                    LockAndCounter lockAndCounter = MemoryLockProvider.this.lockAndCounters.get(lockKey);
                    lockAndCounter.lock.unlock();
                    if (lockAndCounter.counter.decrementAndGet() == 0) {
                        MemoryLockProvider.this.lockAndCounters.compute(lockKey, (key, existingLockAndCounter) -> {
                            if (existingLockAndCounter == null || existingLockAndCounter.counter.get() == 0) {
                                return null;
                            }
                            return existingLockAndCounter;
                        });
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Released lock key " + lockKey);
                    }
                }
            }
        };
    }

    private static class LockAndCounter {
        private final Lock lock = new ReentrantLock();
        private final AtomicInteger counter = new AtomicInteger(0);

        private LockAndCounter() {
        }
    }
}

