/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.imageio.ImageWriteParam;
import org.geotools.util.logging.Logging;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class FormatModifier
implements Serializable {
    private static Logger log = Logging.getLogger((String)FormatModifier.class.getName());
    private String responseFormat;
    private String requestFormat;
    private transient MimeType reqFormat;
    private transient MimeType resFormat;
    private Boolean transparent;
    private String bgColor;
    private String palette;
    private String compressionQuality;
    private transient Float compressQual;
    private transient ImageWriteParam imgWriteParam;

    public synchronized MimeType getRequestFormat() {
        if (this.requestFormat == null) {
            return this.getResponseFormat();
        }
        if (this.reqFormat == null) {
            try {
                this.reqFormat = MimeType.createFromFormat(this.requestFormat);
            }
            catch (MimeException e) {
                log.fine(e.getMessage());
            }
        }
        return this.reqFormat;
    }

    public synchronized MimeType getResponseFormat() {
        if (this.resFormat == null) {
            try {
                this.resFormat = MimeType.createFromFormat(this.responseFormat);
            }
            catch (MimeException e) {
                log.fine(e.getMessage());
            }
        }
        return this.resFormat;
    }

    public Boolean getTransparent() {
        return this.transparent;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public String getPalette() {
        return this.palette;
    }

    private Float getCompressionQuality() {
        if (this.compressionQuality != null && this.compressQual == null) {
            this.compressQual = Float.valueOf(Float.parseFloat(this.compressionQuality));
        }
        return this.compressQual;
    }

    public synchronized ImageWriteParam adjustImageWriteParam(ImageWriteParam param) {
        if (this.imgWriteParam == null) {
            if (this.getCompressionQuality() != null) {
                if (ImageMime.jpeg.equals(this.getResponseFormat())) {
                    param.setCompressionMode(2);
                    param.setCompressionQuality(this.getCompressionQuality().floatValue());
                } else {
                    log.fine("FormatModifier only supports JPEG image parameters at this time.");
                }
            }
            this.imgWriteParam = param;
        }
        return this.imgWriteParam;
    }
}

