/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;

public abstract class GWCTask {
    private static final Logger log = Logging.getLogger((String)GWCTask.class.getName());
    protected AtomicInteger sharedThreadCount = new AtomicInteger();
    protected int threadOffset = 0;
    long taskId = -1L;
    protected TYPE parsedType = TYPE.UNSET;
    protected STATE state = STATE.UNSET;
    protected String layerName = null;
    protected long timeSpent = -1L;
    protected long timeRemaining = -1L;
    protected long tilesDone = -1L;
    protected long tilesTotal = -1L;
    protected boolean terminate = false;
    private long groupStartTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doAction() throws GeoWebCacheException, InterruptedException {
        this.sharedThreadCount.incrementAndGet();
        this.groupStartTime = System.currentTimeMillis();
        try {
            this.doActionInternal();
        }
        finally {
            this.dispose();
            int membersRemaining = this.sharedThreadCount.decrementAndGet();
            if (0 == membersRemaining) {
                double groupTotalTimeSecs = ((double)System.currentTimeMillis() - (double)this.groupStartTime) / 1000.0;
                log.info("Thread group finished " + String.valueOf((Object)this.parsedType) + " task after " + groupTotalTimeSecs + " seconds");
            }
        }
    }

    protected abstract void dispose();

    protected abstract void doActionInternal() throws GeoWebCacheException, InterruptedException;

    public void setThreadInfo(AtomicInteger sharedThreadCount, int threadOffset) {
        this.sharedThreadCount = sharedThreadCount;
        this.threadOffset = threadOffset;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int getThreadCount() {
        return this.sharedThreadCount.get();
    }

    public int getThreadOffset() {
        return this.threadOffset;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public long getTilesTotal() {
        return this.tilesTotal;
    }

    public long getTilesDone() {
        return this.tilesDone;
    }

    public long getTimeRemaining() {
        if (this.tilesTotal > 0L) {
            return this.timeRemaining;
        }
        return -2L;
    }

    public long getTimeSpent() {
        return this.timeSpent;
    }

    public void terminateNicely() {
        this.terminate = true;
    }

    public TYPE getType() {
        return this.parsedType;
    }

    public STATE getState() {
        return this.state;
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            this.state = STATE.DEAD;
            throw new InterruptedException();
        }
    }

    public String toString() {
        return "[" + this.getTaskId() + ": " + this.getLayerName() + ", " + (Object)((Object)this.getType()) + ", " + (Object)((Object)this.getState()) + "]";
    }

    public static enum TYPE {
        UNSET,
        SEED,
        RESEED,
        TRUNCATE;

    }

    public static enum STATE {
        UNSET,
        READY,
        RUNNING,
        DONE,
        DEAD;

    }
}

