/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.SRS;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.TileBreeder;

public class SeedRequest {
    private static Logger log = Logging.getLogger((String)SeedRequest.class.getName());
    private String name = null;
    private BoundingBox bounds = null;
    private String gridSetId;
    private SRS srs;
    private Integer threadCount = null;
    private Integer zoomStart = null;
    private Integer zoomStop = null;
    private String format = null;
    private String type = null;
    private GWCTask.TYPE enumType = null;
    private Map<String, String> parameters = null;
    private Boolean filterUpdate = null;
    private int tileFailureRetryCount = TileBreeder.TILE_FAILURE_RETRY_COUNT_DEFAULT;
    private long tileFailureRetryWaitTime = TileBreeder.TILE_FAILURE_RETRY_WAIT_TIME_DEFAULT;
    private long totalFailuresBeforeAborting = TileBreeder.TOTAL_FAILURES_BEFORE_ABORTING_DEFAULT;

    public SeedRequest() {
    }

    public SeedRequest(String layerName, BoundingBox bounds, String gridSetId, int threadCount, int zoomStart, int zoomStop, String mimeFormat, GWCTask.TYPE type, Map<String, String> parameters) {
        this.name = layerName;
        this.bounds = bounds;
        this.gridSetId = gridSetId;
        this.threadCount = threadCount;
        this.zoomStart = zoomStart;
        this.zoomStop = zoomStop;
        this.format = mimeFormat;
        this.enumType = type;
        this.parameters = parameters;
    }

    public String getLayerName() {
        return this.name;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public boolean getFilterUpdate() {
        if (this.filterUpdate != null) {
            return this.filterUpdate;
        }
        return false;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public String getMimeFormat() {
        return this.format;
    }

    public SRS getSRS() {
        return this.srs;
    }

    public Integer getZoomStart() {
        return this.zoomStart;
    }

    public Integer getZoomStop() {
        return this.zoomStop;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public GWCTask.TYPE getType() {
        if (this.enumType == null) {
            if (this.type == null || this.type.equalsIgnoreCase("seed")) {
                return GWCTask.TYPE.SEED;
            }
            if (this.type.equalsIgnoreCase("reseed")) {
                return GWCTask.TYPE.RESEED;
            }
            if (this.type.equalsIgnoreCase("truncate")) {
                return GWCTask.TYPE.TRUNCATE;
            }
            log.warning("Unknown type \"" + this.type + "\", assuming seed");
            return GWCTask.TYPE.SEED;
        }
        return this.enumType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public int getTileFailureRetryCount() {
        return this.tileFailureRetryCount;
    }

    public void setTileFailureRetryCount(int tileFailureRetryCount) {
        this.tileFailureRetryCount = tileFailureRetryCount;
    }

    public long getTileFailureRetryWaitTime() {
        return this.tileFailureRetryWaitTime;
    }

    public void setTileFailureRetryWaitTime(long tileFailureRetryWaitTime) {
        this.tileFailureRetryWaitTime = tileFailureRetryWaitTime;
    }

    public long getTotalFailuresBeforeAborting() {
        return this.totalFailuresBeforeAborting;
    }

    public void setTotalFailuresBeforeAborting(long totalFailuresBeforeAborting) {
        this.totalFailuresBeforeAborting = totalFailuresBeforeAborting;
    }
}

