/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service;

import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.owasp.encoder.Encode;

public class OWSException
extends Exception {
    private static final long serialVersionUID = -8024005353689857211L;
    int httpCode;
    String exceptionCode;
    String locator;
    String exceptionText;

    public OWSException(int httpCode, String exceptionCode, String locator, String exceptionText) {
        this.httpCode = httpCode;
        this.exceptionCode = Encode.forXml((String)exceptionCode);
        this.locator = Encode.forXml((String)locator);
        this.exceptionText = Encode.forXml((String)exceptionText);
    }

    public int getResponseCode() {
        return this.httpCode;
    }

    public String getContentType() {
        return "text/xml";
    }

    public Resource getResponse() {
        return new ByteArrayResource(this.toString().getBytes());
    }

    @Override
    public String getMessage() {
        return this.exceptionText;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        str.append("<ExceptionReport version=\"1.1.0\" xmlns=\"http://www.opengis.net/ows/1.1\"\n");
        str.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        str.append("  xsi:schemaLocation=\"http://www.opengis.net/ows/1.1 http://geowebcache.org/schema/ows/1.1.0/owsExceptionReport.xsd\">\n");
        if (this.locator != null) {
            str.append("  <Exception exceptionCode=\"" + this.exceptionCode + "\" locator=\"" + this.locator + "\">\n");
        } else {
            str.append("  <Exception exceptionCode=\"" + this.exceptionCode + "\">\n");
        }
        str.append("    <ExceptionText>" + this.exceptionText + "</ExceptionText>\n");
        str.append("  </Exception>\n");
        str.append("</ExceptionReport>\n");
        return str.toString();
    }

    public String getExceptionCode() {
        return this.exceptionCode;
    }

    public String getLocator() {
        return this.locator;
    }
}

