/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.stats;

import java.time.Clock;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.util.ServletUtils;

public class RuntimeStats {
    private static Logger log = Logging.getLogger((String)RuntimeStats.class.getName());
    final int pollInterval;
    final long startTime;
    final int[] intervals;
    final String[] intervalDescs;
    int curBytes = 0;
    int curRequests = 0;
    long peakBytesTime = 0L;
    int peakBytes = 0;
    long peakRequestsTime = 0L;
    int peakRequests = 0;
    long totalBytes = 0L;
    long totalRequests = 0L;
    long totalHits;
    long totalMisses;
    long totalWMS;
    final int[] bytes;
    final int[] requests;
    int ringPos = 0;
    RuntimeStatsThread statsThread;
    private final Clock clock;

    public RuntimeStats(int pollInterval, List<Integer> intervals, List<String> intervalDescs) {
        this(pollInterval, intervals, intervalDescs, Clock.systemUTC());
    }

    public RuntimeStats(int pollInterval, List<Integer> intervals, List<String> intervalDescs, Clock clock) {
        int i;
        this.clock = clock;
        this.startTime = this.clock.millis();
        this.pollInterval = pollInterval;
        if (intervals.size() != intervalDescs.size()) {
            log.severe("The interval and interval description lists must be of the same size!");
        }
        if (pollInterval < 1) {
            log.log(Level.SEVERE, "poll interval cannot be less than 1 second");
        }
        this.intervals = new int[intervals.size()];
        for (i = 0; i < intervals.size(); ++i) {
            int curVal = intervals.get(i);
            if (curVal % pollInterval != 0) {
                log.log(Level.SEVERE, "The interval (" + curVal + ") must be a multiple of the poll interval " + pollInterval);
                curVal -= curVal % pollInterval;
            }
            this.intervals[i] = curVal;
        }
        this.intervalDescs = new String[intervalDescs.size()];
        for (i = 0; i < intervalDescs.size(); ++i) {
            this.intervalDescs[i] = intervalDescs.get(i);
        }
        this.bytes = new int[this.intervals[this.intervals.length - 1] / pollInterval];
        this.requests = new int[this.intervals[this.intervals.length - 1] / pollInterval];
    }

    public void start() {
        this.statsThread = new RuntimeStatsThread(this);
        this.statsThread.start();
    }

    public void destroy() {
        if (this.statsThread != null) {
            this.statsThread.run = false;
            this.statsThread.interrupt();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void log(int size, Conveyor.CacheResult cacheResult) {
        if (this.statsThread == null) return;
        int[] nArray = this.bytes;
        synchronized (this.bytes) {
            this.curBytes += size;
            ++this.curRequests;
            if (cacheResult == Conveyor.CacheResult.HIT) {
                ++this.totalHits;
            } else if (cacheResult == Conveyor.CacheResult.MISS) {
                ++this.totalMisses;
            } else {
                if (cacheResult != Conveyor.CacheResult.WMS) return;
                ++this.totalWMS;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] popIntervalData() {
        int[] nArray = this.bytes;
        synchronized (this.bytes) {
            int[] ret = new int[]{this.curBytes, this.curRequests};
            this.curBytes = 0;
            this.curRequests = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHTMLStats() {
        long runningTime = (this.clock.millis() - this.startTime) / 1000L;
        StringBuilder str = new StringBuilder();
        str.append("<table border=\"0\" cellspacing=\"5\" class=\"stats\">");
        int[] nArray = this.bytes;
        synchronized (this.bytes) {
            if (runningTime > 0L) {
                str.append("<tbody>");
                str.append("<tr><th colspan=\"2\" scope=\"row\">Started:</th><td colspan=\"3\">");
                str.append(ServletUtils.formatTimestamp(this.startTime) + " (" + this.formatTimeDiff(runningTime) + ") ");
                str.append("</td></tr>\n");
                str.append("<tr><th colspan=\"2\" scope=\"row\">Total number of requests:</th><td colspan=\"3\">" + this.totalRequests);
                str.append(" (" + this.totalRequests / runningTime + "/s ) ");
                str.append("</td></tr>\n");
                str.append("<tr><th colspan=\"2\" scope=\"row\">Total number of untiled WMS requests:</th><td colspan=\"3\">" + this.totalWMS);
                str.append(" (" + this.totalWMS / runningTime + "/s ) ");
                str.append("</td></tr>\n");
                str.append("<tr><th colspan=\"2\" scope=\"row\">Total number of bytes:</th><td colspan=\"3\">" + this.totalBytes);
                str.append(" (" + this.formatBits((double)this.totalBytes * 8.0 / (double)runningTime) + ") ");
                str.append("</td></tr>\n");
                str.append("</tbody>");
                str.append("<tbody>");
            } else {
                str.append("<tbody>");
                str.append("<tr><th colspan=\"5\">Runtime stats not yet available, try again in a few seconds.</th></tr>");
                str.append("<tbody>");
            }
            str.append("<tr><th colspan=\"2\" scope=\"row\">Cache hit ratio:</th><td colspan=\"3\">");
            if (this.totalHits + this.totalMisses > 0L) {
                double hitPercentage = (double)this.totalHits * 100.0 / (double)(this.totalHits + this.totalMisses);
                int rounded = (int)Math.round(hitPercentage * 100.0);
                int percents = rounded / 100;
                int decimals = rounded - percents * 100;
                str.append(percents + "." + decimals + "% of requests");
            } else {
                str.append("No data");
            }
            str.append("</td></tr>\n");
            str.append("<tr><th colspan=\"2\" scope=\"row\">Blank/KML/HTML:</th><td colspan=\"3\">");
            if (this.totalRequests > 0L) {
                if (this.totalHits + this.totalMisses == 0L) {
                    str.append("100.0% of requests");
                } else {
                    int rounded = (int)Math.round((double)(this.totalRequests - this.totalHits - this.totalMisses - this.totalWMS) * 100.0 / (double)this.totalRequests);
                    int percents = rounded / 100;
                    int decimals = rounded - percents * 100;
                    str.append(percents + "." + decimals + "% of requests");
                }
            } else {
                str.append("No data");
            }
            str.append("</td></tr>\n");
            str.append("</tbody>");
            str.append("<tbody>");
            str.append("<tr><th colspan=\"2\" scope=\"row\">Peak request rate:</th><td colspan=\"3\">");
            if (this.totalRequests > 0L) {
                str.append(this.formatRequests((double)this.peakRequests * 1.0 / (double)this.pollInterval));
                str.append(" (" + ServletUtils.formatTimestamp(this.peakRequestsTime) + ") ");
            } else {
                str.append("No data");
            }
            str.append("</td></tr>\n");
            str.append("<tr><th colspan=\"2\" scope=\"row\">Peak bandwidth:</th><td colspan=\"3\">");
            if (this.totalRequests > 0L) {
                str.append(this.formatBits((double)this.peakBytes * 8.0 / (double)this.pollInterval));
                str.append(" (" + ServletUtils.formatTimestamp(this.peakRequestsTime) + ") ");
            } else {
                str.append("No data");
            }
            str.append("</td></tr>\n");
            str.append("</tbody>");
            str.append("<tbody>");
            str.append("<tr><th scope=\"col\">Interval</th><th scope=\"col\">Requests</th><th scope=\"col\">Rate</th><th scope=\"col\">Bytes</th><th scope=\"col\">Bandwidth</th></tr>\n");
            for (int i = 0; i < this.intervals.length; ++i) {
                if (runningTime < (long)this.intervals[i]) continue;
                String[] requests = this.calculateRequests(this.intervals[i]);
                String[] bits = this.calculateBits(this.intervals[i]);
                str.append("<tr><td>" + this.intervalDescs[i] + "</td><td>" + requests[0] + "</td><td>" + requests[1] + "</td><td>" + bits[0] + "</td><td>" + bits[1] + "</td><td></tr>\n");
            }
            str.append("</tbody>");
            str.append("<tbody>");
            str.append("<tr><td colspan=\"5\">All figures are " + this.pollInterval + " second(s) delayed and do not include HTTP overhead</td></tr>");
            str.append("<tr><td colspan=\"5\">The cache hit ratio does not account for metatiling</td></tr>");
            str.append("</tbody>");
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return str.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] calculateRequests(int interval) {
        int nodeCount = interval / this.pollInterval;
        int accu = 0;
        int[] nArray = this.bytes;
        synchronized (this.bytes) {
            int pos = (this.ringPos - 1 + this.bytes.length) % this.bytes.length;
            for (int i = 0; i < nodeCount; ++i) {
                accu += this.requests[pos];
                pos = (pos - 1 + this.bytes.length) % this.bytes.length;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            String avg = this.formatRequests((double)accu * 1.0 / (double)interval);
            String[] ret = new String[]{"" + accu, avg};
            return ret;
        }
    }

    private String formatRequests(double requestsps) {
        return (double)Math.round(requestsps * 10.0) / 10.0 + " /s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] calculateBits(int interval) {
        int nodeCount = interval / this.pollInterval;
        int accu = 0;
        int pos = (this.ringPos - 1 + this.bytes.length) % this.bytes.length;
        int[] nArray = this.bytes;
        synchronized (this.bytes) {
            for (int i = 0; i < nodeCount; ++i) {
                accu += this.bytes[pos];
                pos = (pos - 1 + this.bytes.length) % this.bytes.length;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            String avg = this.formatBits((double)accu * 8.0 / (double)interval);
            String[] ret = new String[]{"" + accu, avg};
            return ret;
        }
    }

    private String formatBits(double bitsps) {
        String avg = bitsps > 1000000.0 ? (double)Math.round(bitsps / 100000.0) / 10.0 + "&nbsp;mbps" : (bitsps > 1000.0 ? (double)Math.round(bitsps / 100.0) / 10.0 + "&nbsp;kbps" : (double)Math.round(bitsps * 10.0) / 10.0 + "&nbsp;bps");
        return avg;
    }

    private String formatTimeDiff(long seconds) {
        if (seconds < 3600L) {
            return seconds / 60L + " minutes";
        }
        if (seconds < 172800L) {
            return seconds / 3600L + " hours";
        }
        return seconds / 86400L + " days";
    }

    private class RuntimeStatsThread
    extends Thread {
        final RuntimeStats stats;
        boolean run = true;

        private RuntimeStatsThread(RuntimeStats runtimeStats2) {
            this.stats = runtimeStats2;
        }

        @Override
        public void run() {
            try {
                while (this.run) {
                    Thread.sleep((long)this.stats.pollInterval * 1000L);
                    this.updateLists();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLists() {
            int[] nArray = RuntimeStats.this.bytes;
            synchronized (RuntimeStats.this.bytes) {
                int[] bytesRequests = this.stats.popIntervalData();
                this.stats.totalBytes += (long)bytesRequests[0];
                this.stats.totalRequests += (long)bytesRequests[1];
                if (bytesRequests[0] > RuntimeStats.this.peakBytes) {
                    RuntimeStats.this.peakBytes = bytesRequests[0];
                    RuntimeStats.this.peakBytesTime = RuntimeStats.this.clock.millis();
                }
                if (bytesRequests[1] > RuntimeStats.this.peakRequests) {
                    RuntimeStats.this.peakRequests = bytesRequests[1];
                    RuntimeStats.this.peakRequestsTime = RuntimeStats.this.clock.millis();
                }
                RuntimeStats.this.bytes[RuntimeStats.this.ringPos] = bytesRequests[0];
                RuntimeStats.this.requests[RuntimeStats.this.ringPos] = bytesRequests[1];
                RuntimeStats.this.ringPos = (RuntimeStats.this.ringPos + 1) % RuntimeStats.this.bytes.length;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

