/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

public interface BlobStore {
    public static final Logger log = Logging.getLogger((String)BlobStore.class.getName());

    public boolean delete(String var1) throws StorageException;

    public boolean deleteByGridsetId(String var1, String var2) throws StorageException;

    default public boolean deleteByParameters(String layerName, Map<String, String> parameters) throws StorageException {
        return this.deleteByParametersId(layerName, ParametersUtils.getId(parameters));
    }

    public boolean deleteByParametersId(String var1, String var2) throws StorageException;

    public boolean delete(TileObject var1) throws StorageException;

    public boolean delete(TileRange var1) throws StorageException;

    public boolean get(TileObject var1) throws StorageException;

    public void put(TileObject var1) throws StorageException;

    public void clear() throws StorageException;

    public void destroy();

    public void addListener(BlobStoreListener var1);

    public boolean removeListener(BlobStoreListener var1);

    default public Set<Map<String, String>> getParameters(String layerName) throws StorageException {
        return this.getParametersMapping(layerName).values().stream().flatMap(Optional::stream).collect(Collectors.toSet());
    }

    default public Set<String> getParameterIds(String layerName) throws StorageException {
        return this.getParametersMapping(layerName).keySet();
    }

    public boolean rename(String var1, String var2) throws StorageException;

    public String getLayerMetadata(String var1, String var2);

    public void putLayerMetadata(String var1, String var2, String var3);

    public boolean layerExists(String var1);

    public Map<String, Optional<Map<String, String>>> getParametersMapping(String var1);

    default public boolean purgeOrphans(TileLayer layer) throws StorageException {
        try {
            List<ParameterFilter> parameterFilters = layer.getParameterFilters();
            Function<Map, Boolean> parametersNeedPurge = parameters -> parameters.size() != parameterFilters.size() || parameterFilters.stream().allMatch(pfilter -> {
                String key = pfilter.getKey();
                String value = (String)parameters.get(key);
                if (Objects.isNull(value)) {
                    return true;
                }
                return !pfilter.isFilteredValue(value);
            });
            return this.getParametersMapping(layer.getName()).entrySet().stream().filter(parameterMapping -> ((Optional)parameterMapping.getValue()).map(parametersNeedPurge).orElse(true)).map(Map.Entry::getKey).map(id -> {
                try {
                    return this.deleteByParametersId(layer.getName(), (String)id);
                }
                catch (StorageException e) {
                    throw new UncheckedIOException(e);
                }
            }).reduce((x, y) -> x != false || y != false).orElse(false);
        }
        catch (UncheckedIOException ex) {
            if (ex.getCause() instanceof StorageException) {
                throw (StorageException)ex.getCause();
            }
            throw ex;
        }
    }
}

