/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreConfigurationListener;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.UnsuitableStorageException;
import org.geowebcache.storage.blobstore.file.FileBlobStore;

public class CompositeBlobStore
implements BlobStore,
BlobStoreConfigurationListener {
    static final String GEOWEBCACHE_BLOBSTORE_SUITABILITY_CHECK = "GEOWEBCACHE_BLOBSTORE_SUITABILITY_CHECK";
    private static Logger log = Logging.getLogger((String)CompositeBlobStore.class.getName());
    public static final String DEFAULT_STORE_DEFAULT_ID = "_DEFAULT_STORE_";
    @VisibleForTesting
    Map<String, LiveStore> blobStores = new ConcurrentHashMap<String, LiveStore>();
    private TileLayerDispatcher layers;
    private BlobStoreAggregator blobStoreConfigs;
    private DefaultStorageFinder defaultStorageFinder;
    private LockProvider lockProvider;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();
    private final BlobStoreListenerList listeners = new BlobStoreListenerList();
    @VisibleForTesting
    static final ThreadLocal<StoreSuitabilityCheck> storeSuitability = ThreadLocal.withInitial(() -> Optional.ofNullable(GeoWebCacheExtensions.getProperty(GEOWEBCACHE_BLOBSTORE_SUITABILITY_CHECK)).map(StoreSuitabilityCheck::valueOf).orElse(StoreSuitabilityCheck.EXISTING));

    public static StoreSuitabilityCheck getStoreSuitabilityCheck() {
        return storeSuitability.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeBlobStore(TileLayerDispatcher layers, DefaultStorageFinder defaultStorageFinder, ServerConfiguration serverConfiguration, BlobStoreAggregator blobStoreAggregator) throws StorageException, ConfigurationException {
        this.layers = layers;
        this.defaultStorageFinder = defaultStorageFinder;
        this.lockProvider = serverConfiguration.getLockProvider();
        this.blobStoreConfigs = blobStoreAggregator;
        StoreSuitabilityCheck oldCheck = storeSuitability.get();
        storeSuitability.set(StoreSuitabilityCheck.NONE);
        try {
            this.blobStores = this.loadBlobStores(blobStoreAggregator.getBlobStores());
        }
        finally {
            storeSuitability.set(oldCheck);
        }
        blobStoreAggregator.addListener(this);
    }

    @Override
    public boolean delete(String layerName) throws StorageException {
        return this.readFunctionUnsafe(() -> this.store(layerName).delete(layerName));
    }

    @Override
    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        return this.readFunctionUnsafe(() -> this.store(layerName).deleteByGridsetId(layerName, gridSetId));
    }

    @Override
    public boolean delete(TileObject obj) throws StorageException {
        return this.readFunctionUnsafe(() -> this.store(obj.getLayerName()).delete(obj));
    }

    @Override
    public boolean delete(TileRange obj) throws StorageException {
        return this.readFunctionUnsafe(() -> this.store(obj.getLayerName()).delete(obj));
    }

    @Override
    public boolean get(TileObject obj) throws StorageException {
        return this.readFunctionUnsafe(() -> this.store(obj.getLayerName()).get(obj));
    }

    @Override
    public void put(TileObject obj) throws StorageException {
        this.readActionUnsafe(() -> this.store(obj.getLayerName()).put(obj));
    }

    @Override
    @Deprecated
    public void clear() throws StorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void destroy() {
        this.destroy(this.blobStores);
    }

    private void destroy(Map<String, LiveStore> blobStores) {
        for (LiveStore bs : blobStores.values()) {
            try {
                if (!bs.config.isEnabled()) continue;
                bs.liveInstance.destroy();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error disposing BlobStore " + bs.config.getName(), e);
            }
        }
        blobStores.clear();
    }

    @Override
    public void addListener(BlobStoreListener listener) {
        this.readAction(() -> {
            this.listeners.addListener(listener);
            for (LiveStore bs : this.blobStores.values()) {
                if (!bs.config.isEnabled()) continue;
                bs.liveInstance.addListener(listener);
            }
        });
    }

    @Override
    public boolean removeListener(BlobStoreListener listener) {
        return this.readFunction(() -> {
            this.listeners.removeListener(listener);
            return this.blobStores.values().stream().filter(bs -> bs.config.isEnabled()).map(bs -> bs.liveInstance.removeListener(listener)).collect(Collectors.reducing((x, y) -> x != false || y != false)).orElse(false);
        });
    }

    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        return this.readFunctionUnsafe(() -> {
            for (LiveStore bs : this.blobStores.values()) {
                BlobStoreInfo config = bs.config;
                if (!config.isEnabled() || !bs.liveInstance.rename(oldLayerName, newLayerName)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public String getLayerMetadata(String layerName, String key) {
        return this.readFunction(() -> this.store(layerName).getLayerMetadata(layerName, key));
    }

    @Override
    public void putLayerMetadata(String layerName, String key, String value) {
        this.readAction(() -> this.store(layerName).putLayerMetadata(layerName, key, value));
    }

    @Override
    public boolean layerExists(String layerName) {
        return this.readFunction(() -> this.blobStores.values().stream().anyMatch(bs -> bs.config.isEnabled() && bs.liveInstance.layerExists(layerName)));
    }

    private BlobStore store(String layerId) throws StorageException {
        LiveStore store;
        try {
            store = this.forLayer(layerId);
        }
        catch (GeoWebCacheException e) {
            throw new StorageException(e.getMessage(), e);
        }
        if (!store.config.isEnabled()) {
            throw new StorageException("Attempted to use a blob store that's disabled: " + store.config.getName());
        }
        return store.liveInstance;
    }

    private LiveStore forLayer(String layerName) throws StorageException, GeoWebCacheException {
        TileLayer layer = this.layers.getTileLayer(layerName);
        String storeId = layer.getBlobStoreId();
        LiveStore store = null == storeId ? this.defaultStore() : this.blobStores.get(storeId);
        if (store == null) {
            throw new StorageException("No BlobStore with id '" + storeId + "' found");
        }
        return store;
    }

    private LiveStore defaultStore() throws StorageException {
        LiveStore store = this.blobStores.get(DEFAULT_STORE_DEFAULT_ID);
        if (store == null) {
            throw new StorageException("No default BlobStore has been defined");
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlobStores(Iterable<? extends BlobStoreInfo> configs) throws StorageException, ConfigurationException {
        this.configLock.writeLock().lock();
        try {
            Map<String, LiveStore> newStores = this.loadBlobStores(configs);
            Map<String, LiveStore> oldStores = this.blobStores;
            this.blobStores = newStores;
            for (LiveStore ls : oldStores.values()) {
                if (ls.liveInstance == null) continue;
                ls.liveInstance.destroy();
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    Map<String, LiveStore> loadBlobStores(Iterable<? extends BlobStoreInfo> configs) throws StorageException, ConfigurationException {
        HashMap<String, LiveStore> stores = new HashMap<String, LiveStore>();
        try {
            for (BlobStoreInfo blobStoreInfo : configs) {
                this.loadBlobStore(stores, blobStoreInfo);
            }
            if (!stores.containsKey(DEFAULT_STORE_DEFAULT_ID)) {
                FileBlobStoreInfo config = new FileBlobStoreInfo();
                config.setEnabled(true);
                config.setDefault(true);
                config.setBaseDirectory(this.defaultStorageFinder.getDefaultPath());
                FileBlobStore fileBlobStore = new FileBlobStore(config.getBaseDirectory());
                stores.put(DEFAULT_STORE_DEFAULT_ID, new LiveStore(config, fileBlobStore));
            }
        }
        catch (ConfigurationException | StorageException e) {
            this.destroy(stores);
            throw e;
        }
        return new ConcurrentHashMap<String, LiveStore>(stores);
    }

    private LiveStore loadBlobStore(Map<String, LiveStore> stores, BlobStoreInfo config) throws ConfigurationException, StorageException {
        String id = config.getName();
        boolean enabled = config.isEnabled();
        LiveStore defaultStore = stores.getOrDefault(DEFAULT_STORE_DEFAULT_ID, null);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new ConfigurationException("No id provided for blob store " + String.valueOf(config));
        }
        if (stores.containsKey(id)) {
            throw new ConfigurationException("Duplicate blob store id: " + id + ". Check your configuration.");
        }
        if (DEFAULT_STORE_DEFAULT_ID.equals(id)) {
            throw new ConfigurationException("_DEFAULT_STORE_ is a reserved identifier, please don't use it in the configuration");
        }
        BlobStore store = null;
        if (enabled) {
            store = config.createInstance(this.layers, this.lockProvider);
        }
        LiveStore liveStore = new LiveStore(config, store);
        stores.put(config.getName(), liveStore);
        if (config.isDefault()) {
            if (defaultStore == null || defaultStore.config.getName().equals(config.getName())) {
                if (!enabled) {
                    throw new ConfigurationException("The default blob store can't be disabled: " + config.getName());
                }
                stores.put(DEFAULT_STORE_DEFAULT_ID, liveStore);
            } else {
                throw new ConfigurationException("Duplicate default blob store: " + defaultStore.config.getName() + " and " + config.getName());
            }
        }
        return liveStore;
    }

    @Override
    public boolean deleteByParametersId(String layerName, String parametersId) throws StorageException {
        return this.readFunctionUnsafe(() -> this.store(layerName).deleteByParametersId(layerName, parametersId));
    }

    @Override
    public Set<Map<String, String>> getParameters(String layerName) {
        return this.readFunction(() -> this.store(layerName).getParameters(layerName));
    }

    @Override
    public Set<String> getParameterIds(String layerName) {
        return this.readFunction(() -> this.store(layerName).getParameterIds(layerName));
    }

    protected <T> T readFunctionUnsafe(StorageAccessor<T> function) throws StorageException {
        this.configLock.readLock().lock();
        try {
            T t = function.get();
            return t;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    protected <T> T readFunction(StorageAccessor<T> function) {
        try {
            return this.readFunctionUnsafe(function);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readActionUnsafe(StorageAction function) throws StorageException {
        this.readFunctionUnsafe(() -> {
            function.run();
            return null;
        });
    }

    protected void readAction(StorageAction function) {
        this.readFunction(() -> {
            function.run();
            return null;
        });
    }

    @Override
    public Map<String, Optional<Map<String, String>>> getParametersMapping(String layerName) {
        return this.readFunction(() -> this.store(layerName).getParametersMapping(layerName));
    }

    @Override
    public void handleAddBlobStore(BlobStoreInfo newBlobStore) throws ConfigurationException, StorageException {
        if (newBlobStore.isDefault()) {
            this.loadBlobStoreOverwritingDefault(this.blobStores, newBlobStore);
        } else {
            this.loadBlobStore(this.blobStores, newBlobStore);
        }
    }

    @Override
    public void handleRemoveBlobStore(BlobStoreInfo removedBlobStore) throws ConfigurationException, StorageException {
        if (removedBlobStore.getName().equals(this.blobStores.get((Object)DEFAULT_STORE_DEFAULT_ID).config.getName())) {
            throw new ConfigurationException("The default blob store can't be removed: " + removedBlobStore.getName());
        }
        this.blobStores.remove(removedBlobStore.getName());
    }

    @Override
    public void handleModifyBlobStore(BlobStoreInfo modifiedBlobStore) throws ConfigurationException, StorageException {
        LiveStore removedStore = this.blobStores.remove(modifiedBlobStore.getName());
        try {
            if (modifiedBlobStore.isDefault() && !modifiedBlobStore.getName().equals(this.blobStores.get((Object)DEFAULT_STORE_DEFAULT_ID).config.getName())) {
                this.loadBlobStoreOverwritingDefault(this.blobStores, modifiedBlobStore);
            } else {
                this.loadBlobStore(this.blobStores, modifiedBlobStore);
            }
        }
        catch (ConfigurationException | StorageException e) {
            this.blobStores.put(modifiedBlobStore.getName(), removedStore);
            throw e;
        }
    }

    @Override
    public void handleRenameBlobStore(String oldName, BlobStoreInfo modifiedBlobStore) throws ConfigurationException, StorageException {
        block6: {
            LiveStore removedStore = this.blobStores.remove(oldName);
            try {
                if (modifiedBlobStore.isDefault()) {
                    BlobStoreInfo oldConfig = this.blobStores.get((Object)DEFAULT_STORE_DEFAULT_ID).config;
                    if (oldName.equals(oldConfig.getName()) || modifiedBlobStore.equals(oldConfig)) {
                        try {
                            this.blobStores.get((Object)DEFAULT_STORE_DEFAULT_ID).config = modifiedBlobStore;
                            this.loadBlobStore(this.blobStores, modifiedBlobStore);
                            break block6;
                        }
                        catch (ConfigurationException | StorageException e) {
                            this.blobStores.get((Object)DEFAULT_STORE_DEFAULT_ID).config = oldConfig;
                            throw e;
                        }
                    }
                    log.warning("Changing default blobstore during rename, this should not happen");
                    this.loadBlobStoreOverwritingDefault(this.blobStores, modifiedBlobStore);
                    break block6;
                }
                this.loadBlobStore(this.blobStores, modifiedBlobStore);
            }
            catch (ConfigurationException | StorageException e) {
                this.blobStores.put(oldName, removedStore);
                throw e;
            }
        }
    }

    private void loadBlobStoreOverwritingDefault(Map<String, LiveStore> stores, BlobStoreInfo config) throws StorageException, ConfigurationException {
        LiveStore oldDefaultStore = stores.get(DEFAULT_STORE_DEFAULT_ID);
        try {
            stores.remove(DEFAULT_STORE_DEFAULT_ID);
            this.loadBlobStore(stores, config);
            if (null != oldDefaultStore.config.getName()) {
                oldDefaultStore.config.setDefault(false);
                this.blobStoreConfigs.modifyBlobStore(oldDefaultStore.config);
            }
        }
        catch (ConfigurationException | StorageException e) {
            stores.put(DEFAULT_STORE_DEFAULT_ID, oldDefaultStore);
            oldDefaultStore.config.setDefault(true);
            throw e;
        }
    }

    public static void checkSuitability(String location, boolean exists, boolean empty) throws UnsuitableStorageException {
        switch (CompositeBlobStore.getStoreSuitabilityCheck()) {
            case EXISTING: {
                if (exists) break;
            }
            case EMPTY: {
                if (empty) break;
                throw new UnsuitableStorageException("Attempted to create Blob Store in " + location + " but it was not empty");
            }
        }
    }

    public static enum StoreSuitabilityCheck {
        NONE,
        EXISTING,
        EMPTY;

    }

    @FunctionalInterface
    static interface StorageAccessor<T> {
        public T get() throws StorageException;
    }

    @FunctionalInterface
    static interface StorageAction {
        public void run() throws StorageException;
    }

    @VisibleForTesting
    static final class LiveStore {
        BlobStoreInfo config;
        BlobStore liveInstance;

        public LiveStore(BlobStoreInfo config, @Nullable BlobStore store) {
            Preconditions.checkArgument((config.isEnabled() == (store != null) ? 1 : 0) != 0);
            this.config = config;
            this.liveInstance = store;
        }
    }
}

