/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Map;
import java.util.TreeMap;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.mime.MimeType;

public class TileRange {
    private final String layerName;
    private final String gridSetId;
    private final int zoomStart;
    private final int zoomStop;
    private final Map<Integer, long[]> rangeBounds;
    private final MimeType mimeType;
    private final Map<String, String> parameters;
    private String parametersId;

    public TileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, long[][] rangeBounds, MimeType mimeType, Map<String, String> parameters) {
        this(layerName, gridSetId, zoomStart, zoomStop, rangeBounds, mimeType, parameters, ParametersUtils.getId(parameters));
    }

    public TileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, long[][] rangeBounds, MimeType mimeType, Map<String, String> parameters, String parametersId) {
        this.layerName = layerName;
        this.gridSetId = gridSetId;
        if (rangeBounds == null) {
            this.rangeBounds = null;
        } else {
            this.rangeBounds = new TreeMap<Integer, long[]>();
            for (long[] bounds : rangeBounds) {
                if (bounds == null) continue;
                this.rangeBounds.put((int)bounds[4], bounds);
            }
        }
        this.zoomStart = zoomStart;
        this.zoomStop = zoomStop;
        this.mimeType = mimeType;
        this.parameters = parameters;
        this.parametersId = parametersId;
    }

    public boolean contains(long[] idx) {
        return this.contains(idx[0], idx[1], (int)idx[2]);
    }

    public boolean contains(long x, long y, int z) {
        long[] rB;
        if (null == this.rangeBounds) {
            return true;
        }
        return z >= this.getZoomStart() && z <= this.getZoomStop() && (rB = this.rangeBounds(z))[0] <= x && rB[2] >= x && rB[1] <= y && rB[3] >= y;
    }

    public void setParametersId(String parametersId) {
        this.parametersId = parametersId;
    }

    public String getParametersId() {
        return this.parametersId;
    }

    public int getZoomStart() {
        return this.zoomStart;
    }

    public int getZoomStop() {
        return this.zoomStop;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public long[] rangeBounds(int zoomLevel) {
        if (zoomLevel < this.zoomStart) {
            throw new IllegalArgumentException(zoomLevel + " < zoomStart (" + this.zoomStart + ")");
        }
        if (zoomLevel > this.zoomStop) {
            throw new IllegalArgumentException(zoomLevel + " > zoomStop (" + this.zoomStop + ")");
        }
        long[] zlevelBounds = this.rangeBounds.get(zoomLevel);
        if (zlevelBounds == null) {
            throw new IllegalStateException("Found no range bounds for z level " + zoomLevel + ": " + String.valueOf(this.rangeBounds));
        }
        return zlevelBounds;
    }
}

