/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.DefaultFilePathFilter;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.geowebcache.storage.blobstore.file.TileFileVisitor;
import org.geowebcache.util.FileUtils;

public class DefaultFilePathGenerator
implements FilePathGenerator {
    private static Logger log = Logging.getLogger((String)DefaultFilePathGenerator.class.getName());
    String cacheRoot;

    public DefaultFilePathGenerator(String cacheRoot) {
        this.cacheRoot = cacheRoot;
    }

    @Override
    public File tilePath(TileObject tile, MimeType mimeType) {
        long[] tileIndex = tile.getXYZ();
        long x = tileIndex[0];
        long y = tileIndex[1];
        long z = tileIndex[2];
        StringBuilder path = new StringBuilder(256);
        long shift = z / 2L;
        long half = 2L << (int)shift;
        int digits = 1;
        if (half > 10L) {
            digits = (int)Math.log10(half) + 1;
        }
        long halfx = x / half;
        long halfy = y / half;
        String fileExtension = mimeType.getFileExtension();
        path.append(this.cacheRoot);
        path.append(File.separatorChar);
        FilePathUtils.appendFiltered(tile.getLayerName(), path);
        path.append(File.separatorChar);
        FilePathUtils.appendGridsetZoomLevelDir(tile.getGridSetId(), z, path);
        String parametersId = tile.getParametersId();
        Map<String, String> parameters = tile.getParameters();
        if (parametersId == null && parameters != null && !parameters.isEmpty()) {
            parametersId = ParametersUtils.getId(parameters);
            tile.setParametersId(parametersId);
        }
        if (parametersId != null) {
            path.append('_');
            path.append(parametersId);
        }
        path.append(File.separatorChar);
        FilePathUtils.zeroPadder(halfx, digits, path);
        path.append('_');
        FilePathUtils.zeroPadder(halfy, digits, path);
        path.append(File.separatorChar);
        FilePathUtils.zeroPadder(x, 2 * digits, path);
        path.append('_');
        FilePathUtils.zeroPadder(y, 2 * digits, path);
        path.append('.');
        path.append(fileExtension);
        File tileFile = new File(path.toString());
        return tileFile;
    }

    @Override
    public void visitRange(File layerDirectory, TileRange range, TileFileVisitor visitor) throws StorageException {
        DefaultFilePathFilter tileFinder = new DefaultFilePathFilter(range);
        File[] srsZoomDirs = FileUtils.listFilesNullSafe(layerDirectory, tileFinder);
        String gridsetPrefix = FilePathUtils.filteredGridSetId(range.getGridSetId());
        for (File srsZoomParamId : srsZoomDirs) {
            File[] intermediates;
            visitor.preVisitDirectory(srsZoomParamId);
            int zoomLevel = FilePathUtils.findZoomLevel(gridsetPrefix, srsZoomParamId.getName());
            for (File imd : intermediates = FileUtils.listFilesNullSafe(srsZoomParamId, tileFinder)) {
                File[] tiles;
                visitor.preVisitDirectory(imd);
                for (File tile : tiles = FileUtils.listFilesNullSafe(imd, tileFinder)) {
                    String[] coords = tile.getName().split("\\.")[0].split("_");
                    long x = Long.parseLong(coords[0]);
                    long y = Long.parseLong(coords[1]);
                    visitor.visitFile(tile, x, y, zoomLevel);
                }
                visitor.postVisitDirectory(imd);
            }
            visitor.postVisitDirectory(srsZoomParamId);
        }
    }
}

