/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;

public class FilePathUtils {
    public static String gridsetZoomLevelDir(String gridSetId, long zoomLevel) {
        String gridSetStr = FilePathUtils.filteredGridSetId(gridSetId);
        StringBuilder sb = new StringBuilder(gridSetStr);
        sb.append('_');
        FilePathUtils.zeroPadder(zoomLevel, 2, sb);
        return sb.toString();
    }

    public static String zeroPadder(long number, int order) {
        StringBuilder sb = new StringBuilder();
        FilePathUtils.zeroPadder(number, order, sb);
        return sb.toString();
    }

    public static void zeroPadder(long number, int order, StringBuilder padding) {
        int diffOrder;
        int numberOrder = 1;
        if (number > 9L) {
            numberOrder = number > 11L ? (int)Math.ceil(Math.log10(number) - 0.001) : 2;
        }
        if ((diffOrder = order - numberOrder) > 0) {
            while (diffOrder > 0) {
                padding.append('0');
                --diffOrder;
            }
            padding.append(number);
        } else {
            padding.append(number);
        }
    }

    public static String filteredGridSetId(String gridSetId) {
        return gridSetId.replace(':', '_');
    }

    public static String filteredLayerName(String layerName) {
        return layerName.replace(':', '_').replace(' ', '_');
    }

    public static void appendFiltered(String str, StringBuilder path) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (':' == c || ' ' == c) {
                c = '_';
            }
            path.append(c);
        }
    }

    public static int findZoomLevel(String gridsetPrefix, String dirName) {
        assert (dirName.startsWith(gridsetPrefix + "_"));
        String[] parts = dirName.substring(gridsetPrefix.length() + 1).split("_");
        String zlevel = parts[0];
        try {
            return Integer.parseInt(zlevel);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("unable to find zoom level in '%s'".formatted(gridsetPrefix), e);
        }
    }

    public static String findParameter(String gridsetPrefix, String dirName) {
        assert (dirName.startsWith(gridsetPrefix + "_"));
        String[] parts = dirName.substring(gridsetPrefix.length() + 1).split("_");
        if (parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    public static void appendGridsetZoomLevelDir(String gridSetId, long z, StringBuilder path) {
        FilePathUtils.appendFiltered(gridSetId, path);
        path.append('_');
        FilePathUtils.zeroPadder(z, 2, path);
    }

    public static String buildPath(String root, String ... components) {
        StringBuilder path = new StringBuilder(256);
        path.append(root);
        for (String component : components) {
            path.append(File.separatorChar);
            FilePathUtils.appendFiltered(component, path);
        }
        return path.toString();
    }
}

