/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class GWCVars {
    private static final Logger log = Logging.getLogger((String)GWCVars.class.toString());
    public static final int CACHE_VALUE_UNSET = 0;
    public static final int CACHE_DISABLE_CACHE = -1;
    public static final int CACHE_NEVER_EXPIRE = -2;
    public static final int CACHE_USE_WMS_BACKEND_VALUE = -4;

    public static String findEnvVar(ApplicationContext context, String varStr) {
        return GWCVars.lookup(context, varStr).map(GWCVars::log).filter(GWCVars::nonNullValue).findFirst().map(Variable::getValue).orElse(null);
    }

    public static List<Variable> findVariable(ApplicationContext context, String varName) {
        return GWCVars.lookup(context, varName).collect(Collectors.toList());
    }

    private static Stream<Variable> lookup(ApplicationContext context, String varName) {
        return Arrays.stream(VariableType.values()).map(t -> t.get(context, varName));
    }

    private static boolean nonNullValue(Variable v) {
        return v.getValue() != null;
    }

    private static Variable log(Variable v) {
        String value = v.getValue();
        String source = v.getType().getSource();
        String name = v.getName();
        if (value == null && log.isLoggable(Level.FINER)) {
            log.config("Not found " + source + " for " + name);
        } else if (value != null && log.isLoggable(Level.INFO)) {
            log.config("Found " + source + " for " + name + " set to " + value);
        }
        return v;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum VariableType {
        ENV("Java system property"){

            @Override
            protected String apply(ApplicationContext context, String varName) {
                return System.getProperty(varName);
            }
        }
        ,
        SERVLET("servlet context parameter"){

            @Override
            protected String apply(ApplicationContext context, String varName) {
                if (context instanceof WebApplicationContext) {
                    WebApplicationContext applicationContext = (WebApplicationContext)context;
                    ServletContext servletContext = applicationContext.getServletContext();
                    return servletContext == null ? null : servletContext.getInitParameter(varName);
                }
                return null;
            }
        }
        ,
        SYSTEM("system environment variable"){

            @Override
            protected String apply(ApplicationContext context, String varName) {
                return System.getenv(varName);
            }
        };

        private final String source;

        private VariableType(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }

        protected abstract String apply(ApplicationContext var1, String var2);

        Variable get(ApplicationContext context, String varName) {
            return Variable.ofNullable(this, varName, this.apply(context, varName));
        }
    }

    public static class Variable {
        private final VariableType type;
        private final String name;
        private final String value;

        private Variable(VariableType type, String name, String value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public VariableType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        static Variable ofNullable(VariableType type, String name, String nullableValue) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(name);
            return new Variable(type, name, nullableValue);
        }
    }
}

