/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

public final class TMSKeyBuilder {
    private static final String DELIMITER = "/";
    public static final String LAYER_METADATA_OBJECT_NAME = "metadata.properties";
    public static final String PARAMETERS_METADATA_OBJECT_PREFIX = "parameters-";
    public static final String PARAMETERS_METADATA_OBJECT_SUFFIX = ".properties";
    public static final String PENDING_DELETES = "_pending_deletes.properties";
    private String prefix;
    private TileLayerDispatcher layers;

    public TMSKeyBuilder(String prefix, TileLayerDispatcher layers) {
        this.prefix = prefix;
        this.layers = layers;
    }

    public String layerId(String layerName) {
        TileLayer layer;
        try {
            layer = this.layers.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        return layer.getId();
    }

    public String layerNameFromId(String layerId) {
        for (TileLayer tileLayer : this.layers.getLayerList()) {
            if (!layerId.equals(tileLayer.getId())) continue;
            return tileLayer.getName();
        }
        return null;
    }

    public Set<String> layerGridsets(String layerName) {
        TileLayer layer;
        try {
            layer = this.layers.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        return layer.getGridSubsets();
    }

    public Set<String> layerFormats(String layerName) {
        TileLayer layer;
        try {
            layer = this.layers.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        return layer.getMimeTypes().stream().map(MimeType::getFileExtension).collect(Collectors.toSet());
    }

    public String forTile(TileObject obj) {
        String extension;
        String shortFormat;
        Preconditions.checkNotNull((Object)obj.getLayerName());
        Preconditions.checkNotNull((Object)obj.getGridSetId());
        Preconditions.checkNotNull((Object)obj.getBlobFormat());
        Preconditions.checkNotNull((Object)obj.getXYZ());
        String layer = this.layerId(obj.getLayerName());
        String gridset = obj.getGridSetId();
        String parametersId = obj.getParametersId();
        if (parametersId == null) {
            Map<String, String> parameters = obj.getParameters();
            parametersId = ParametersUtils.getId(parameters);
            if (parametersId == null) {
                parametersId = "default";
            } else {
                obj.setParametersId(parametersId);
            }
        }
        Long x = obj.getXYZ()[0];
        Long y = obj.getXYZ()[1];
        Long z = obj.getXYZ()[2];
        try {
            String format = obj.getBlobFormat();
            MimeType mimeType = MimeType.createFromFormat(format);
            shortFormat = mimeType.getFileExtension();
            extension = mimeType.getInternalName();
        }
        catch (MimeException e) {
            throw new RuntimeException(e);
        }
        String key = TMSKeyBuilder.join(false, this.prefix, layer, gridset, shortFormat, parametersId, z, x, y + "." + extension);
        return key;
    }

    public String forLocation(String prefix, long[] loc, MimeType mime) {
        Long x = loc[0];
        Long y = loc[1];
        Long z = loc[2];
        String extension = mime.getInternalName();
        return TMSKeyBuilder.join(false, prefix, z, x, y + "." + extension);
    }

    public String forLayer(String layerName) {
        String layerId = this.layerId(layerName);
        return TMSKeyBuilder.join(true, this.prefix, layerId);
    }

    public String forGridset(String layerName, String gridsetId) {
        String layerId = this.layerId(layerName);
        return TMSKeyBuilder.join(true, this.prefix, layerId, gridsetId);
    }

    public Set<String> forParameters(String layerName, String parametersId) {
        String layerId = this.layerId(layerName);
        HashSet<String> set = new HashSet<String>();
        for (String gridsetId : this.layerGridsets(layerName)) {
            for (String format : this.layerFormats(layerName)) {
                String join = TMSKeyBuilder.join(true, this.prefix, layerId, gridsetId, format, parametersId);
                set.add(join);
            }
        }
        return set;
    }

    public String layerMetadata(String layerName) {
        String layerId = this.layerId(layerName);
        return TMSKeyBuilder.join(false, this.prefix, layerId, LAYER_METADATA_OBJECT_NAME);
    }

    public String storeMetadata() {
        return TMSKeyBuilder.join(false, this.prefix, LAYER_METADATA_OBJECT_NAME);
    }

    public String parametersMetadata(String layerName, String parametersId) {
        String layerId = this.layerId(layerName);
        return TMSKeyBuilder.join(false, this.prefix, layerId, PARAMETERS_METADATA_OBJECT_PREFIX + parametersId + PARAMETERS_METADATA_OBJECT_SUFFIX);
    }

    public String parametersMetadataPrefix(String layerName) {
        String layerId = this.layerId(layerName);
        return TMSKeyBuilder.join(false, this.prefix, layerId, PARAMETERS_METADATA_OBJECT_PREFIX);
    }

    public String coordinatesPrefix(TileRange obj, boolean endWithSlash) {
        Preconditions.checkNotNull((Object)obj.getLayerName());
        Preconditions.checkNotNull((Object)obj.getGridSetId());
        Preconditions.checkNotNull((Object)obj.getMimeType());
        String layer = this.layerId(obj.getLayerName());
        String gridset = obj.getGridSetId();
        MimeType mimeType = obj.getMimeType();
        String parametersId = obj.getParametersId();
        if (parametersId == null) {
            Map<String, String> parameters = obj.getParameters();
            parametersId = ParametersUtils.getId(parameters);
            if (parametersId == null) {
                parametersId = "default";
            } else {
                obj.setParametersId(parametersId);
            }
        }
        String shortFormat = mimeType.getFileExtension();
        String key = TMSKeyBuilder.join(endWithSlash, this.prefix, layer, gridset, shortFormat, parametersId);
        return key;
    }

    public String pendingDeletes() {
        if (!Strings.isNullOrEmpty((String)this.prefix)) {
            return "%s/%s".formatted(this.prefix, PENDING_DELETES);
        }
        return PENDING_DELETES;
    }

    private static String join(boolean closing, Object ... elements) {
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Object o : elements) {
            String s;
            String string = s = o == null ? null : o.toString();
            if (Strings.isNullOrEmpty((String)s)) continue;
            joiner.add(s);
        }
        if (closing) {
            joiner.add("");
        }
        return joiner.toString();
    }

    private static String parametersFromTileRange(TileRange obj) {
        String parametersId = obj.getParametersId();
        if (parametersId == null) {
            Map<String, String> parameters = obj.getParameters();
            parametersId = ParametersUtils.getId(parameters);
            if (parametersId == null) {
                parametersId = "default";
            } else {
                obj.setParametersId(parametersId);
            }
        }
        return parametersId;
    }

    public String forZoomLevel(TileRange tileRange, int level) {
        String layerId = this.layerId(tileRange.getLayerName());
        String gridsetId = tileRange.getGridSetId();
        String format = tileRange.getMimeType().getFileExtension();
        String parametersId = TMSKeyBuilder.parametersFromTileRange(tileRange);
        return TMSKeyBuilder.join(true, this.prefix, layerId, gridsetId, format, parametersId, String.valueOf(level));
    }
}

