/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.io.range.FieldType;
import org.geotools.coverage.io.range.RangeType;
import org.geotools.feature.NameImpl;
import org.geotools.util.SimpleInternationalString;

public class DefaultRangeType
implements RangeType {
    private InternationalString description;
    private Name name;
    private Set<FieldType> fieldTypes;
    private Set<Name> fieldTypesNames;

    public DefaultRangeType(String name, String description, FieldType fieldType) {
        this(new NameImpl(name), (InternationalString)new SimpleInternationalString(description), Collections.singleton(fieldType));
    }

    public DefaultRangeType(String name, String description, Set<FieldType> fieldTypes) {
        this(new NameImpl(name), (InternationalString)new SimpleInternationalString(description), fieldTypes);
    }

    public DefaultRangeType(Name name, InternationalString description, Set<FieldType> fieldTypes) {
        this.name = name;
        this.description = description;
        this.fieldTypes = new LinkedHashSet<FieldType>(fieldTypes);
        this.fieldTypesNames = new LinkedHashSet<Name>(fieldTypes.size());
        for (FieldType fieldType : fieldTypes) {
            this.fieldTypesNames.add(fieldType.getName());
        }
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public FieldType getFieldType(String name) {
        for (FieldType fieldType : this.fieldTypes) {
            Name ftName = fieldType.getName();
            String localPart = name;
            String nameSpace = "";
            if (name.contains(":")) {
                int indexOf = name.lastIndexOf(":");
                localPart = name.substring(indexOf + 1, localPart.length());
                nameSpace = name.substring(0, indexOf);
            }
            String ftLocalPart = ftName.getLocalPart().toString();
            String ftNameSpace = ftName.getNamespaceURI();
            if (!ftLocalPart.equals(localPart)) continue;
            if (ftNameSpace != null && ftNameSpace.equals(nameSpace)) {
                return fieldType;
            }
            return fieldType;
        }
        return null;
    }

    @Override
    public Set<Name> getFieldTypeNames() {
        return Collections.unmodifiableSet(this.fieldTypesNames);
    }

    @Override
    public Set<FieldType> getFieldTypes() {
        return Collections.unmodifiableSet(this.fieldTypes);
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public int getNumFieldTypes() {
        return this.fieldTypes.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator", "\n");
        sb.append("Name:").append(this.name.toString()).append(lineSeparator);
        sb.append("Description:").append(this.description.toString()).append(lineSeparator);
        sb.append("FieldTypes:").append(lineSeparator);
        for (FieldType fieldType : this.fieldTypes) {
            sb.append("fieldType:").append(fieldType.toString());
            sb.append(lineSeparator).append(lineSeparator);
        }
        return sb.toString();
    }
}

