/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.georss.GeoRSSPollTask;
import org.geowebcache.georss.PollDef;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.seed.TileBreeder;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class GeoRSSPoller {
    private static final Logger LOGGER = Logging.getLogger((String)GeoRSSPoller.class.getName());
    private final TileBreeder seeder;
    private final ScheduledExecutorService schedulingPollExecutorService;
    private final List<PollDef> scheduledPolls;
    private final List<GeoRSSPollTask> scheduledTasks;

    public GeoRSSPoller(TileBreeder seeder, int startUpDelaySecs) {
        this.seeder = seeder;
        this.scheduledPolls = new ArrayList<PollDef>();
        this.scheduledTasks = new ArrayList<GeoRSSPollTask>();
        boolean corePoolSize = true;
        CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC GeoRSS Poll Tasks-");
        tf.setDaemon(true);
        tf.setThreadPriority(2);
        this.schedulingPollExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)tf);
        this.schedulingPollExecutorService.submit(() -> {
            this.findEnabledPolls();
            if (this.pollCount() > 0) {
                LOGGER.fine("Initializing GeoRSS poller in a background job...");
                TimeUnit seconds = TimeUnit.SECONDS;
                for (PollDef poll : this.scheduledPolls) {
                    GeoRSSPollTask command = new GeoRSSPollTask(poll, seeder);
                    GeoRSSFeedDefinition pollDef = poll.getPollDef();
                    long period = pollDef.getPollInterval();
                    LOGGER.config("Scheduling layer " + poll.getLayer().getName() + " to poll the GeoRSS feed " + pollDef.getFeedUrl() + " every " + pollDef.getPollIntervalStr());
                    this.schedulingPollExecutorService.scheduleAtFixedRate(command, startUpDelaySecs, period, seconds);
                    this.scheduledTasks.add(command);
                }
                LOGGER.fine("Will wait " + startUpDelaySecs + " seconds before launching the " + this.pollCount() + " GeoRSS polls found");
            } else {
                LOGGER.fine("No enabled GeoRSS feeds found, poller will not run.");
            }
        });
    }

    private void findEnabledPolls() {
        Iterable layers = this.seeder.getLayers();
        for (TileLayer layer : layers) {
            if (layer.getUpdateSources().isEmpty()) continue;
            if (!layer.isEnabled()) {
                LOGGER.info("Ignoring polling GeoRSS update sources for layer '" + layer.getName() + "' as the layer is disabled");
            }
            for (UpdateSourceDefinition usd : layer.getUpdateSources()) {
                if (!(usd instanceof GeoRSSFeedDefinition)) continue;
                GeoRSSFeedDefinition georssDef = (GeoRSSFeedDefinition)usd;
                String gridSetId = georssDef.getGridSetId();
                GridSubset gridSubset = layer.getGridSubset(gridSetId);
                if (gridSubset == null) {
                    throw new IllegalStateException("Layer " + layer.getName() + " has no grid subset " + gridSetId + " as configured by its GeoRSS seeding feed " + String.valueOf(georssDef));
                }
                if (georssDef.getPollInterval() > 0) {
                    LOGGER.info("Scheduling GeoRSS feed for layer " + layer.getName() + ":" + String.valueOf(georssDef));
                    this.scheduledPolls.add(new PollDef(layer, georssDef));
                    continue;
                }
                LOGGER.info("Feed disabled for layer " + layer.getName() + ", ignoring: " + String.valueOf(georssDef));
            }
        }
    }

    public int pollCount() {
        return this.scheduledPolls.size();
    }

    public void destroy() {
        LOGGER.fine("destroy() invoked");
        if (this.schedulingPollExecutorService != null) {
            this.schedulingPollExecutorService.shutdown();
        }
        for (GeoRSSPollTask task : this.scheduledTasks) {
            task.stopSeeding(false);
        }
    }
}

