/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.geotools.util.logging.Logging;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.StaxGeoRSSReader;
import org.geowebcache.util.HttpClientBuilder;

class GeoRSSReaderFactory {
    private static final Logger log = Logging.getLogger((String)GeoRSSReaderFactory.class.getName());

    GeoRSSReaderFactory() {
    }

    public GeoRSSReader createReader(URL url, String username, String password) throws IOException {
        String contentEncoding;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating GeoRSS reader for URL " + url.toExternalForm() + " with user " + username);
        }
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setHttpCredentials(username, password, url);
        builder.setBackendTimeout(120);
        HttpClient httpClient = builder.buildClient();
        HttpGet getMethod = new HttpGet(url.toString());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing HTTP GET requesr for feed URL " + url.toExternalForm());
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Building GeoRSS reader out of URL response");
        }
        if ((contentEncoding = response.getEntity().getContentEncoding().getValue()) == null) {
            contentEncoding = "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), contentEncoding));
        if (log.isLoggable(Level.FINE)) {
            log.fine("GeoRSS reader created, returning.");
        }
        return this.createReader(reader);
    }

    public GeoRSSReader createReader(Reader feed) throws IOException {
        StaxGeoRSSReader reader;
        try {
            reader = new StaxGeoRSSReader(feed);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return reader;
    }
}

