/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.classbreaks;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.classbreaks.ClassBreaksOpImage;
import org.eclipse.imagen.media.classbreaks.ClassPercentagesManager;
import org.eclipse.imagen.media.classbreaks.Classification;
import org.eclipse.imagen.media.classbreaks.HistogramClassification;

public class NaturalBreaksHistogramOpImage
extends ClassBreaksOpImage {
    int numBins;

    public NaturalBreaksHistogramOpImage(RenderedImage image, Integer numClasses, Double[][] extrema, ROI roi, Integer[] bands, Integer xStart, Integer yStart, Integer xPeriod, Integer yPeriod, Double noData, int numBins, Boolean percentages) {
        super(image, numClasses, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
        this.numBins = numBins;
    }

    @Override
    protected Classification createClassification() {
        return new HistogramClassification(this.bands.length, this.extrema, this.numBins);
    }

    @Override
    protected void handleValue(double d, Classification c, int band) {
        ((HistogramClassification)c).count(d, band);
    }

    @Override
    protected void postCalculate(Classification c, int band) {
        HistogramClassification hc = (HistogramClassification)c;
        List<HistogramClassification.Bucket> buckets = hc.getBuckets(band);
        int k = this.numClasses;
        int m = buckets.size();
        TreeSet<Double> breaks = new TreeSet<Double>();
        if (k >= m) {
            Double[] arrBreaks = new Double[m + 1];
            for (int i = 0; i < m; ++i) {
                arrBreaks[i] = buckets.get(i).getMin();
            }
            arrBreaks[m] = buckets.get(m - 1).getMax();
            c.setBreaks(band, arrBreaks);
            this.setPercentages(k, arrBreaks.length, buckets, Arrays.asList(arrBreaks), c);
            return;
        }
        int[][] iwork = new int[m + 1][k + 1];
        double[][] work = new double[m + 1][k + 1];
        for (int j = 1; j <= k; ++j) {
            iwork[0][j] = 1;
            iwork[1][j] = 1;
            work[1][j] = 0.0;
            for (int i = 2; i <= m; ++i) {
                work[i][j] = Double.MAX_VALUE;
            }
        }
        for (int i = 1; i <= m; ++i) {
            double s1 = 0.0;
            double s2 = 0.0;
            double var = 0.0;
            int totalCount = 0;
            for (int ii = 1; ii <= i; ++ii) {
                int i3 = i - ii + 1;
                HistogramClassification.Bucket bucket = buckets.get(i3 - 1);
                double average = bucket.getAverage();
                int count = bucket.getCount();
                double s0 = totalCount += count;
                var = (s2 += average * average * (double)count) - (s1 += average * (double)count) * s1 / s0;
                int ik = i3 - 1;
                if (ik == 0) continue;
                for (int j = 2; j <= k; ++j) {
                    if (!(work[i][j] >= var + work[ik][j - 1])) continue;
                    iwork[i][j] = i3 - 1;
                    work[i][j] = var + work[ik][j - 1];
                }
            }
            iwork[i][1] = 1;
            work[i][1] = var;
        }
        int ik = m - 1;
        breaks.add(buckets.get(ik).getMax());
        for (int j = k; j >= 2; --j) {
            int id = iwork[ik][j] - 1;
            breaks.add(buckets.get(id).getAverage());
            ik = iwork[ik][j] - 1;
        }
        breaks.add(buckets.get(0).getMin());
        int breaksSize = breaks.size();
        hc.setBreaks(band, breaks.toArray(new Double[breaksSize]));
        this.setPercentages(k, breaksSize, buckets, new ArrayList<Double>(breaks), hc);
    }

    private void setPercentages(int k, int breaksSize, List<HistogramClassification.Bucket> buckets, List<Double> breaks, Classification hc) {
        if (this.percentages.booleanValue()) {
            int actualClassNumber = k >= breaksSize ? breaksSize - 1 : k;
            ClassPercentagesManager percentagesManager = new ClassPercentagesManager();
            double[] percentages = percentagesManager.getPercentages(buckets, new ArrayList<Double>(breaks), actualClassNumber);
            hc.setPercentages(percentages);
        }
    }
}

