/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.classbreaks;

import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.classbreaks.ClassBreaksOpImage;
import org.eclipse.imagen.media.classbreaks.ClassPercentagesManager;
import org.eclipse.imagen.media.classbreaks.Classification;
import org.eclipse.imagen.media.classbreaks.NaturalClassification;

public class NaturalBreaksOpImage
extends ClassBreaksOpImage {
    public NaturalBreaksOpImage(RenderedImage image, Integer numClasses, Double[][] extrema, ROI roi, Integer[] bands, Integer xStart, Integer yStart, Integer xPeriod, Integer yPeriod, Double noData, Boolean percentages) {
        super(image, numClasses, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
    }

    @Override
    protected Classification createClassification() {
        return new NaturalClassification(this.bands.length);
    }

    @Override
    protected void handleValue(double d, Classification c, int band) {
        if (this.extrema != null) {
            double min = this.extrema[0][band];
            double max = this.extrema[1][band];
            if (d < min || d > max) {
                return;
            }
        }
        ((NaturalClassification)c).count(d, band);
    }

    @Override
    protected void postCalculate(Classification c, int band) {
        NaturalClassification nc = (NaturalClassification)c;
        List<Double> data = nc.getValues(band);
        Collections.sort(data);
        int k = this.numClasses;
        int m = data.size();
        if (k >= m) {
            Double[] breaks = data.toArray(new Double[data.size()]);
            c.setBreaks(band, breaks);
            this.setPercentages(data, breaks, m, k, c);
            return;
        }
        int[][] iwork = new int[m + 1][k + 1];
        double[][] work = new double[m + 1][k + 1];
        for (int j = 1; j <= k; ++j) {
            iwork[0][j] = 1;
            iwork[1][j] = 1;
            work[1][j] = 0.0;
            for (int i = 2; i <= m; ++i) {
                work[i][j] = Double.MAX_VALUE;
            }
        }
        for (int i = 1; i <= m; ++i) {
            double s1 = 0.0;
            double s2 = 0.0;
            double var = 0.0;
            for (int ii = 1; ii <= i; ++ii) {
                int i3 = i - ii + 1;
                double val = data.get(i3 - 1);
                double s0 = ii;
                var = (s2 += val * val) - (s1 += val) * s1 / s0;
                int ik = i3 - 1;
                if (ik == 0) continue;
                for (int j = 2; j <= k; ++j) {
                    if (!(work[i][j] >= var + work[ik][j - 1])) continue;
                    iwork[i][j] = i3 - 1;
                    work[i][j] = var + work[ik][j - 1];
                }
            }
            iwork[i][1] = 1;
            work[i][1] = var;
        }
        TreeSet<Double> breaks = new TreeSet<Double>();
        int ik = m - 1;
        breaks.add(data.get(ik));
        for (int j = k; j >= 2; --j) {
            int id = iwork[ik][j] - 1;
            breaks.add(data.get(id));
            ik = iwork[ik][j] - 1;
        }
        breaks.add(data.get(0));
        Double[] arrBreaks = breaks.toArray(new Double[breaks.size()]);
        nc.setBreaks(band, arrBreaks);
        this.setPercentages(data, arrBreaks, m, k, nc);
    }

    private void setPercentages(List<Double> data, Double[] breaks, int m, int k, Classification nc) {
        if (this.percentages.booleanValue()) {
            ClassPercentagesManager percentagesManager = new ClassPercentagesManager();
            int actualClassNumber = k > breaks.length ? breaks.length - 1 : k;
            double[] percentages = percentagesManager.getPercentages(data, breaks, (double)m, actualClassNumber);
            nc.setPercentages(percentages);
        }
    }
}

