/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.classbreaks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imagen.media.classbreaks.Classification;
import org.eclipse.imagen.media.classbreaks.ClassificationMethod;

public class NaturalClassification
extends Classification {
    List<Double>[] values;

    public NaturalClassification(int numBands) {
        super(ClassificationMethod.NATURAL_BREAKS, numBands);
        this.values = new List[numBands];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ArrayList<Double>();
        }
    }

    public NaturalClassification(ClassificationMethod method, int numBands) {
        super(method, numBands);
        this.values = new List[numBands];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ArrayList<Double>();
        }
    }

    public void count(double value, int band) {
        this.values[band].add(value);
    }

    public List<Double> getValues(int band) {
        return this.values[band];
    }
}

