/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.xsd.EMFUtils;

public class EMFKvpRequestReader
extends KvpRequestReader {
    protected EFactory factory;

    public EMFKvpRequestReader(Class<?> requestBean, EFactory factory) {
        super(requestBean);
        if (!EObject.class.isAssignableFrom(requestBean)) {
            String msg = "Request bean must be an EObject";
            throw new IllegalArgumentException(msg);
        }
        this.factory = factory;
    }

    @Override
    public Object createRequest() {
        String className = this.getRequestBean().getName();
        int index = className.lastIndexOf(46);
        if (index != -1) {
            className = className.substring(index + 1);
        }
        Method create = OwsUtils.method(this.factory.getClass(), "create" + className);
        try {
            return create.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object read(Object request, Map<String, Object> kvp, Map<String, Object> rawKvp) throws Exception {
        EObject eObject = (EObject)request;
        for (Map.Entry<String, Object> entry : kvp.entrySet()) {
            String property = entry.getKey();
            Object value = entry.getValue();
            if (this.filter(property) || !EMFUtils.has((EObject)eObject, (String)property)) continue;
            try {
                this.setValue(eObject, property, value);
            }
            catch (Exception ex) {
                throw new ServiceException("Failed to set property " + property + " in request object using value " + String.valueOf(value) + (String)(value != null ? " of type " + String.valueOf(value.getClass()) : ""), (Throwable)ex, "InvalidParameterValue", property);
            }
        }
        return request;
    }

    protected void setValue(EObject eObject, String property, Object value) {
        if (EMFUtils.isCollection((EObject)eObject, (String)property)) {
            EMFUtils.add((EObject)eObject, (String)property, (Object)value);
        } else {
            EMFUtils.set((EObject)eObject, (String)property, (Object)value);
        }
    }
}

