/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CaseInsensitiveMap<K extends String, V>
implements Map<K, V> {
    Map<K, V> delegate = new TreeMap();

    public CaseInsensitiveMap(Map<K, V> delegate) {
        this.putAll(delegate);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(this.upper(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(this.upper(key));
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put((String)this.upper(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            String key = (String)entry.getKey();
            V value = entry.getValue();
            this.put((K)key, value);
        }
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(this.upper(key));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    <T> T upper(T key) {
        if (key != null && key instanceof String) {
            String string = (String)key;
            return (T)string.toUpperCase();
        }
        return key;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static <V> Map<String, V> wrap(Map<String, V> other) {
        if (other instanceof CaseInsensitiveMap) {
            return other;
        }
        return new CaseInsensitiveMap<String, V>(other);
    }
}

