/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.geoserver.ows.util.RequestObjectLogger;

public class EMFLogger
extends RequestObjectLogger {
    public EMFLogger(String logPackage) {
        super(logPackage);
    }

    @Override
    protected boolean isRequestObject(Object obj) {
        return obj instanceof EObject;
    }

    @Override
    protected void log(Object obj, int level, StringBuffer log) {
        EObject object = (EObject)obj;
        EList properties = object.eClass().getEAllStructuralFeatures();
        for (Object o : properties) {
            Map map;
            Collection collection;
            EStructuralFeature property = (EStructuralFeature)o;
            Object value = object.eGet(property);
            if (value == null || value instanceof Collection && (collection = (Collection)value).isEmpty() || value instanceof Map && (map = (Map)value).isEmpty()) continue;
            log.append("\n");
            for (int i = 0; i < level; ++i) {
                log.append("    ");
            }
            if (value instanceof EObject && level < 3) {
                log.append(property.getName());
                log.append(":");
                this.log(value, level + 1, log);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection2 = (Collection)value;
                this.log(property.getName(), collection2, level + 1, log);
                continue;
            }
            log.append(property.getName());
            log.append(" = " + String.valueOf(value));
        }
    }

    protected void log(String property, Collection collection, int level, StringBuffer log) {
        int count = 0;
        for (Object o : collection) {
            String pc = property + "[" + count + "]";
            if (o instanceof EObject) {
                log.append(pc);
                log.append(":");
                this.log(o, level, log);
                continue;
            }
            if (o instanceof Collection) {
                Collection collection1 = (Collection)o;
                this.log(pc, collection1, level + 1, log);
                continue;
            }
            log.append(pc).append(" = " + String.valueOf(o));
        }
    }
}

