/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensions;

public class ResponseUtils {
    public static final String SCHEMAS = "schemas";

    public static String encodeXML(String inData) {
        if (inData == null) {
            return null;
        }
        if (inData.indexOf(38) == -1 && inData.indexOf(60) == -1 && inData.indexOf(62) == -1 && inData.indexOf(39) == -1 && inData.indexOf(34) == -1) {
            return inData;
        }
        int length = inData.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        for (int i = 0; i < length; ++i) {
            char charToCompare = inData.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '>') {
                writer.write("&gt;");
                continue;
            }
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '\'') {
                writer.write("&apos;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            writer.write(c);
        }
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return url + queryString;
        }
        if (url.indexOf(63) != -1) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }

    public static String stripQueryString(String url) {
        int index = url.indexOf(63);
        if (index == -1) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String getQueryString(String url) {
        int index = url.indexOf(63);
        if (index == -1 || index == url.length() - 1) {
            return "";
        }
        return url.substring(index + 1);
    }

    public static String getPath(String uri) {
        try {
            return new URI(uri).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getParentUrl(String url) {
        int index;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((index = url.lastIndexOf(47)) == -1) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String appendPath(String ... pathComponents) {
        StringBuilder result = new StringBuilder(pathComponents[0]);
        for (int i = 1; i < pathComponents.length; ++i) {
            String component = pathComponents[i];
            boolean endsWithSlash = result.charAt(result.length() - 1) == '/';
            boolean startsWithSlash = component.startsWith("/");
            if (endsWithSlash && startsWithSlash) {
                result.setLength(result.length() - 1);
            } else if (!endsWithSlash && !startsWithSlash) {
                result.append("/");
            }
            result.append(component);
        }
        return result.toString();
    }

    public static String stripRemainingPath(String path) {
        int index;
        int i = 0;
        if (path.startsWith("/")) {
            i = 1;
        }
        if ((index = path.indexOf(47, i)) > -1) {
            return path.substring(0, index);
        }
        return path;
    }

    public static String stripBeginningPath(String path) {
        int index;
        int i = 0;
        if (path.startsWith("/")) {
            i = 1;
        }
        if ((index = path.indexOf(47, i)) > -1) {
            return path.substring(index + 1);
        }
        return "";
    }

    public static String stripExtension(String path) {
        String ext = ResponseUtils.getExtension(path);
        if (ext != null) {
            return path.substring(0, path.length() - ext.length() - 1);
        }
        return path;
    }

    public static String getLastPartOfPath(String path) {
        int j;
        int i = path.length();
        if (path.endsWith("/")) {
            --i;
        }
        if ((j = path.lastIndexOf("/")) == -1) {
            return path;
        }
        return path.substring(j + 1, i);
    }

    public static String getExtension(String uri) {
        int dot;
        int slash = uri.lastIndexOf(47);
        if (slash != -1) {
            uri = uri.substring(slash + 1);
        }
        if ((dot = uri.lastIndexOf(46)) != -1) {
            return uri.substring(dot + 1);
        }
        return null;
    }

    public static String makePathAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    public static String buildURL(String baseURL, String path, Map<String, String> kvp, URLMangler.URLType type) {
        StringBuilder baseURLBuffer = new StringBuilder(baseURL);
        StringBuilder pathBuffer = new StringBuilder(path != null ? path : "");
        LinkedHashMap<String, String> kvpBuffer = new LinkedHashMap<String, String>();
        if (kvp != null) {
            kvpBuffer.putAll(kvp);
        }
        for (URLMangler mangler : GeoServerExtensions.extensions(URLMangler.class)) {
            mangler.mangleURL(baseURLBuffer, pathBuffer, kvpBuffer, type);
        }
        String result = ResponseUtils.appendPath(baseURLBuffer.toString(), pathBuffer.toString());
        StringBuilder params = new StringBuilder();
        for (Map.Entry entry : kvpBuffer.entrySet()) {
            params.append((String)entry.getKey());
            params.append("=");
            String value = (String)entry.getValue();
            if (value != null) {
                String encoded = ResponseUtils.urlEncode(value, new char[0]);
                params.append(encoded);
            }
            params.append("&");
        }
        if (params.length() > 1) {
            params.setLength(params.length() - 1);
            result = ResponseUtils.appendQueryString(result, params.toString());
        }
        return result;
    }

    public static String buildSchemaURL(String baseURL, String path) {
        return ResponseUtils.buildURL(baseURL, ResponseUtils.appendPath(SCHEMAS, path), null, URLMangler.URLType.RESOURCE);
    }

    public static String baseURL(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getScheme());
        sb.append("://").append(req.getServerName());
        if (!("http".equals(req.getScheme()) && req.getServerPort() == 80 || "https".equals(req.getScheme()) && req.getServerPort() == 443)) {
            sb.append(":").append(req.getServerPort());
        }
        sb.append(req.getContextPath()).append("/");
        return sb.toString();
    }

    public static Map<String, String> params(String ... parameters) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("The parameters sequence should be composed of key/value pairs, but the params passed are odd in number");
        }
        int i = 0;
        while (i < parameters.length) {
            String key = parameters[i++];
            String value = parameters[i++];
            result.put(key, value);
        }
        return result;
    }

    public static String urlEncode(String value, char ... exclude) {
        byte[] encArray;
        StringBuilder resultStr = new StringBuilder();
        for (byte enc : encArray = value.getBytes(StandardCharsets.UTF_8)) {
            if (enc >= 65 && enc <= 90 || enc >= 97 && enc <= 122 || enc >= 48 && enc <= 57 || enc == 45 || enc == 95 || enc == 46 || enc == 126 || ArrayUtils.contains((char[])exclude, (char)((char)enc))) {
                resultStr.append((char)enc);
                continue;
            }
            resultStr.append("%%%02X".formatted(enc));
        }
        return resultStr.toString();
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This is unexpected", e);
        }
    }
}

