/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.crop;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.media.crop.CropOpImage;
import org.eclipse.imagen.media.mosaic.MosaicDescriptor;
import org.eclipse.imagen.media.mosaic.MosaicOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;

public class CropCRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderingHints) {
        Rectangle bounds;
        RenderedImage image = (RenderedImage)paramBlock.getSource(0);
        float x = paramBlock.getFloatParameter(0);
        float y = paramBlock.getFloatParameter(1);
        float width = paramBlock.getFloatParameter(2);
        float height = paramBlock.getFloatParameter(3);
        ROI roi = (ROI)paramBlock.getObjectParameter(4);
        Range noData = (Range)paramBlock.getObjectParameter(5);
        noData = RangeFactory.convert((Range)noData, (int)image.getSampleModel().getDataType());
        double[] destNoData = (double[])paramBlock.getObjectParameter(6);
        HashMap<RenderingHints.Key, Object> tmp = new HashMap<RenderingHints.Key, Object>();
        for (Object key : renderingHints.keySet()) {
            if (key != ImageN.KEY_TILE_CACHE && key != ImageN.KEY_TILE_SCHEDULER) continue;
            tmp.put((RenderingHints.Key)key, renderingHints.get(key));
        }
        RenderingHints local = new RenderingHints(tmp);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)local);
        Rectangle finalBounds = bounds = new Rectangle2D.Float(x, y, width, height).getBounds();
        if (roi != null) {
            Rectangle roiBounds = roi.getBounds();
            if (finalBounds.contains(roiBounds)) {
                finalBounds = roiBounds;
            } else {
                finalBounds.intersection(roiBounds);
            }
        }
        x = (float)finalBounds.getMinX();
        y = (float)finalBounds.getMinY();
        width = (float)finalBounds.getWidth();
        height = (float)finalBounds.getHeight();
        if (noData != null) {
            roi = new ROIShape((Shape)finalBounds);
            Vector<RenderedImage> listSrc = new Vector<RenderedImage>();
            listSrc.add(image);
            if (layout == null) {
                layout = new ImageLayout();
            }
            layout.setHeight(finalBounds.height);
            layout.setWidth(finalBounds.width);
            layout.setMinX(finalBounds.x);
            layout.setMinY(finalBounds.y);
            image = new MosaicOpImage(listSrc, layout, (Map)local, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, new ROI[]{roi}, null, destNoData, new Range[]{noData});
            return image;
        }
        return new CropOpImage(image, x, y, width, height, local);
    }
}

