/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.crop;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Map;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.PointOpImage;

public class CropOpImage
extends PointOpImage {
    private static ImageLayout layoutHelper(RenderedImage source, float originX, float originY, float width, float height) {
        Rectangle bounds = new Rectangle2D.Float(originX, originY, width, height).getBounds();
        return new ImageLayout(bounds.x, bounds.y, bounds.width, bounds.height, source.getTileGridXOffset(), source.getTileGridYOffset(), source.getTileWidth(), source.getTileHeight(), source.getSampleModel(), source.getColorModel());
    }

    public CropOpImage(RenderedImage source, float originX, float originY, float width, float height, Map configuration) {
        super(source, CropOpImage.layoutHelper(source, originX, originY, width, height), configuration, false);
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster computeTile(int tileX, int tileY) {
        return this.getTile(tileX, tileY);
    }

    public Raster getTile(int tileX, int tileY) {
        if (tileX >= this.getMinTileX() && tileX <= this.getMaxTileX() && tileY >= this.getMinTileY() && tileY <= this.getMaxTileY()) {
            return this.getSourceImage(0).getTile(tileX, tileY);
        }
        return null;
    }
}

