/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.File;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.jdbc.config.JDBCConnectAuthProviderConfig;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidator;

public class JdbcSecurityConfigValidator
extends SecurityConfigValidator {
    public JdbcSecurityConfigValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    public void validate(SecurityRoleServiceConfig config) throws SecurityConfigException {
        super.validate(config);
        JDBCSecurityServiceConfig jdbcConfig = (JDBCSecurityServiceConfig)config;
        this.validateFileNames(jdbcConfig, "rolesddl.xml", "rolesdml.xml");
        this.checkAutomaticTableCreation(jdbcConfig);
        if (jdbcConfig.isJndi()) {
            this.validateJNDI(jdbcConfig);
        } else {
            this.validateJDBC(jdbcConfig);
        }
    }

    public void validate(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        super.validate(config);
        JDBCSecurityServiceConfig jdbcConfig = (JDBCSecurityServiceConfig)config;
        this.validateFileNames(jdbcConfig, "usersddl.xml", "usersdml.xml");
        this.checkAutomaticTableCreation(jdbcConfig);
        if (jdbcConfig.isJndi()) {
            this.validateJNDI(jdbcConfig);
        } else {
            this.validateJDBC(jdbcConfig);
        }
    }

    protected void checkAutomaticTableCreation(JDBCSecurityServiceConfig config) throws SecurityConfigException {
        if (config.isCreatingTables() && !this.isNotEmpty(config.getPropertyFileNameDDL())) {
            throw this.createSecurityException("DDL_FILE_REQUIRED", new Object[0]);
        }
    }

    protected void validateFileNames(JDBCSecurityServiceConfig config, String defaultDDL, String defaultDML) throws SecurityConfigException {
        File file;
        String fileName = config.getPropertyFileNameDDL();
        if (this.isNotEmpty(fileName) && !defaultDDL.equals(fileName) && !this.checkFile(file = new File(fileName))) {
            throw this.createSecurityException("DDL_FILE_INVALID", new Object[]{fileName});
        }
        fileName = config.getPropertyFileNameDML();
        if (!this.isNotEmpty(fileName)) {
            throw this.createSecurityException("DML_FILE_REQUIRED", new Object[0]);
        }
        if (!defaultDML.equals(fileName) && !this.checkFile(file = new File(fileName))) {
            throw this.createSecurityException("DML_FILE_INVALID", new Object[]{fileName});
        }
    }

    protected void validateJNDI(JDBCSecurityServiceConfig config) throws SecurityConfigException {
        if (!this.isNotEmpty(config.getJndiName())) {
            throw this.createSecurityException("JNDINAME_REQUIRED", new Object[0]);
        }
    }

    protected void validateJDBC(JDBCSecurityServiceConfig config) throws SecurityConfigException {
        if (!this.isNotEmpty(config.getDriverClassName())) {
            throw this.createSecurityException("DRIVER_CLASSNAME_REQUIRED", new Object[0]);
        }
        if (!this.isNotEmpty(config.getUserName())) {
            throw this.createSecurityException("USERNAME_REQUIRED", new Object[0]);
        }
        if (!this.isNotEmpty(config.getConnectURL())) {
            throw this.createSecurityException("JDBCURL_REQUIRED", new Object[0]);
        }
        try {
            Class.forName(config.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw this.createSecurityException("DRIVER_CLASS_NOTFOUND", new Object[]{config.getDriverClassName()});
        }
    }

    public void validate(SecurityAuthProviderConfig config) throws SecurityConfigException {
        super.validate(config);
        JDBCConnectAuthProviderConfig jdbcConfig = (JDBCConnectAuthProviderConfig)config;
        if (!this.isNotEmpty(jdbcConfig.getDriverClassName())) {
            throw this.createSecurityException("DRIVER_CLASSNAME_REQUIRED", new Object[0]);
        }
        if (!this.isNotEmpty(jdbcConfig.getConnectURL())) {
            throw this.createSecurityException("JDBCURL_REQUIRED", new Object[0]);
        }
        try {
            Class.forName(jdbcConfig.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw this.createSecurityException("DRIVER_CLASS_NOTFOUND", new Object[]{jdbcConfig.getDriverClassName()});
        }
    }
}

