/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.GWCSettingsPage;
import org.geoserver.gwc.web.GWCTileLayerIconCustomizer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerBasePage;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;

public class GWCIconFactory
implements Serializable {
    public static final PackageResourceReference UNKNOWN_ICON = new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/error.png");
    public static final PackageResourceReference DISABLED_ICON = new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/error.png");
    public static final PackageResourceReference ENABLED_ICON = new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/tick.png");
    public static final PackageResourceReference ADD_ICON = new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/add.png");
    public static final PackageResourceReference DELETE_ICON = new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/delete.png");
    public static final PackageResourceReference GRIDSET = new PackageResourceReference(GWCSettingsPage.class, "gridset.png");
    public static final PackageResourceReference GWC = new PackageResourceReference(GWCSettingsPage.class, "geowebcache-16.png");

    private GWCIconFactory() {
    }

    public static CachedLayerType getCachedLayerType(TileLayer layer) {
        if (layer instanceof GeoServerTileLayer) {
            GeoServerTileLayer gsTileLayer = (GeoServerTileLayer)layer;
            PublishedInfo published = gsTileLayer.getPublishedInfo();
            PublishedType publishedType = published.getType();
            return CachedLayerType.valueOf(publishedType.getCode());
        }
        if (layer instanceof WMSLayer) {
            return CachedLayerType.GWC;
        }
        List iconCustomizers = GeoServerExtensions.extensions(GWCTileLayerIconCustomizer.class);
        for (GWCTileLayerIconCustomizer iconCustomizer : iconCustomizers) {
            CachedLayerType cachedLayerType = iconCustomizer.getCachedLayerType(layer);
            if (cachedLayerType == null || cachedLayerType == CachedLayerType.UNKNOWN) continue;
            return cachedLayerType;
        }
        return CachedLayerType.UNKNOWN;
    }

    public static PackageResourceReference getSpecificLayerIcon(TileLayer layer) {
        if (layer instanceof GeoServerTileLayer) {
            GeoServerTileLayer gsTileLayer = (GeoServerTileLayer)layer;
            PublishedInfo published = gsTileLayer.getPublishedInfo();
            if (published instanceof LayerInfo) {
                LayerInfo info = (LayerInfo)published;
                return CatalogIconFactory.get().getSpecificLayerIcon(info);
            }
            return CatalogIconFactory.GROUP_ICON;
        }
        if (layer instanceof WMSLayer) {
            return GWC;
        }
        List iconCustomizers = GeoServerExtensions.extensions(GWCTileLayerIconCustomizer.class);
        for (GWCTileLayerIconCustomizer iconCustomizer : iconCustomizers) {
            PackageResourceReference ref = iconCustomizer.getLayerIcon(layer);
            if (ref == null || ref == UNKNOWN_ICON) continue;
            return ref;
        }
        return UNKNOWN_ICON;
    }

    public static PackageResourceReference getEnabledIcon() {
        return ENABLED_ICON;
    }

    public static PackageResourceReference getDisabledIcon() {
        return DISABLED_ICON;
    }

    public static PackageResourceReference getErrorIcon() {
        return UNKNOWN_ICON;
    }

    public static enum CachedLayerType {
        VECTOR(PublishedType.VECTOR.getCode()),
        RASTER(PublishedType.RASTER.getCode()),
        REMOTE(PublishedType.REMOTE.getCode()),
        WMS(PublishedType.WMS.getCode()),
        GROUP(PublishedType.GROUP.getCode()),
        WMTS(PublishedType.WMTS.getCode()),
        GWC(-1),
        UNKNOWN(-2);

        private final Integer code;

        private CachedLayerType(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return this.code;
        }

        public static CachedLayerType valueOf(Integer code) {
            return CachedLayerType.values()[code];
        }
    }
}

