/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.geoserver.gwc.web.blob.BlobStoreType;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreInfo;

public final class BlobStoreTypes {
    private static Map<Class<? extends BlobStoreInfo>, BlobStoreType<?>> TYPES;

    private BlobStoreTypes() {
    }

    private static Map<Class<? extends BlobStoreInfo>, BlobStoreType<?>> getTypes() {
        if (TYPES == null) {
            TreeMap tmp = new TreeMap(Comparator.comparing(Object::toString));
            for (BlobStoreType type : GeoWebCacheExtensions.extensions(BlobStoreType.class)) {
                tmp.put(type.getConfigClass(), type);
            }
            TYPES = tmp;
        }
        return TYPES;
    }

    public static BlobStoreType<?> getFromClass(Class<? extends BlobStoreInfo> clazz) {
        return BlobStoreTypes.getTypes().get(clazz);
    }

    public static List<BlobStoreType<?>> getAll() {
        return new ArrayList(BlobStoreTypes.getTypes().values());
    }
}

