/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStorePage;
import org.geoserver.gwc.web.blob.BlobStoreTypes;
import org.geoserver.gwc.web.blob.BlobStoresProvider;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.layer.TileLayer;

public class BlobStoresPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 6076989713813458347L;
    private AjaxLink<Object> remove;
    private GeoServerTablePanel<BlobStoreInfo> blobStoresPanel;
    private GeoServerDialog dialog;

    public BlobStoresPage() {
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("confirmDeleteDialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmDeleteDialog.title", (Component)this.getPage(), new Object[0]));
        this.dialog.setInitialHeight(200);
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new AjaxLink<Object>("addNew"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new BlobStorePage());
            }
        }});
        Component[] componentArray2 = new Component[1];
        this.remove = new RemoveSelectedLink();
        componentArray2[0] = this.remove;
        header.add(componentArray2);
        this.remove.setOutputMarkupId(true);
        this.remove.setEnabled(false);
        this.setHeaderPanel((Component)header);
        Component[] componentArray3 = new Component[1];
        this.blobStoresPanel = new BlobStoreTable();
        componentArray3[0] = this.blobStoresPanel;
        this.add(componentArray3);
        this.blobStoresPanel.setOutputMarkupId(true);
    }

    private class RemoveSelectedLink
    extends AjaxLink<Object> {
        private static final long serialVersionUID = 1L;

        public RemoveSelectedLink() {
            super("removeSelected");
        }

        public void onClick(AjaxRequestTarget target) {
            final HashSet<String> ids = new HashSet<String>();
            final ArrayList<String> assignedLayers = new ArrayList<String>();
            for (BlobStoreInfo config : BlobStoresPage.this.blobStoresPanel.getSelection()) {
                if (config.isDefault()) {
                    this.error((Serializable)((Object)new ParamResourceModel("deleteError", (Component)this.getPage(), new Object[0]).getString()));
                    BlobStoresPage.this.addFeedbackPanels(target);
                    return;
                }
                ids.add(config.getName());
            }
            for (TileLayer layer : GWC.get().getTileLayers()) {
                if (layer.getBlobStoreId() == null || !ids.contains(layer.getBlobStoreId())) continue;
                assignedLayers.add(layer.getName());
            }
            if (!assignedLayers.isEmpty()) {
                BlobStoresPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                    private static final long serialVersionUID = 5257987095800108993L;
                    private String error = null;

                    protected Component getContents(String id) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(new ParamResourceModel("confirmDeleteDialog.content", (Component)RemoveSelectedLink.this.getPage(), new Object[0]).getString());
                        for (String layerName : assignedLayers) {
                            sb.append("\n&nbsp;&nbsp;");
                            sb.append(StringEscapeUtils.escapeHtml4((String)layerName));
                        }
                        return new MultiLineLabel("userPanel", sb.toString()).setEscapeModelStrings(false);
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        try {
                            GWC.get().removeBlobStores((Iterable)ids);
                            for (String layerName : assignedLayers) {
                                TileLayer layer = GWC.get().getTileLayerByName(layerName);
                                layer.setBlobStoreId(null);
                                GWC.get().save(layer);
                            }
                        }
                        catch (ConfigurationException e) {
                            this.error = e.getMessage();
                        }
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        if (this.error != null) {
                            RemoveSelectedLink.this.error((Serializable)((Object)this.error));
                            BlobStoresPage.this.addFeedbackPanels(target);
                        } else {
                            target.add(new Component[]{BlobStoresPage.this.blobStoresPanel});
                        }
                    }
                });
            } else {
                try {
                    GWC.get().removeBlobStores(ids);
                }
                catch (ConfigurationException e) {
                    this.error((Serializable)((Object)e.toString()));
                    BlobStoresPage.this.addFeedbackPanels(target);
                }
                target.add(new Component[]{BlobStoresPage.this.blobStoresPanel});
            }
        }
    }

    private class BlobStoreTable
    extends GeoServerTablePanel<BlobStoreInfo> {
        private static final long serialVersionUID = -5380703588873422601L;

        public BlobStoreTable() {
            super("storesPanel", (GeoServerDataProvider)new BlobStoresProvider(), true);
        }

        protected Component getComponentForProperty(String id, IModel<BlobStoreInfo> itemModel, GeoServerDataProvider.Property<BlobStoreInfo> property) {
            final BlobStoreInfo blobStore = (BlobStoreInfo)itemModel.getObject();
            if (property == BlobStoresProvider.ID) {
                return new SimpleAjaxLink<BlobStoreInfo>(id, itemModel, property.getModel(itemModel)){
                    private static final long serialVersionUID = 1L;

                    protected void onClick(AjaxRequestTarget target) {
                        this.setResponsePage((IRequestablePage)new BlobStorePage(blobStore));
                    }
                };
            }
            if (property == BlobStoresProvider.DEFAULT) {
                if (blobStore.isDefault()) {
                    return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                }
                return new Label(id, (Serializable)((Object)""));
            }
            if (property == BlobStoresProvider.ENABLED) {
                if (blobStore.isEnabled()) {
                    return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                }
                return new Label(id, (Serializable)((Object)""));
            }
            if (property == BlobStoresProvider.TYPE) {
                return new Label(id, (Serializable)((Object)BlobStoreTypes.getFromClass(blobStore.getClass()).toString()));
            }
            return null;
        }

        protected void onSelectionUpdate(AjaxRequestTarget target) {
            BlobStoresPage.this.remove.setEnabled(!BlobStoresPage.this.blobStoresPanel.getSelection().isEmpty());
            target.add(new Component[]{BlobStoresPage.this.remove});
        }
    }
}

