/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;

class GridSubsetsEditor
extends FormComponentPanel<Set<XMLGridSubset>> {
    private static final long serialVersionUID = 5098470663723800345L;
    private final WebMarkupContainer table;
    private final ListView<XMLGridSubset> grids;
    private final DropDownChoice<String> availableGridSets;
    private final GridSubsetListValidator validator = new GridSubsetListValidator();

    public GridSubsetsEditor(String id, IModel<Set<XMLGridSubset>> model) {
        super(id, model);
        this.add(this.validator);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add(new Component[]{this.table});
        this.grids = new ListView<XMLGridSubset>("gridSubsets", new ArrayList((Collection)model.getObject())){
            private static final long serialVersionUID = 1L;

            protected void onBeforeRender() {
                super.onBeforeRender();
            }

            protected void populateItem(ListItem<XMLGridSubset> item) {
                int gridsetLevels;
                boolean gridsetExists;
                int index = item.getIndex();
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(index % 2 == 0 ? "even" : "odd")))});
                XMLGridSubset gridSubset = (XMLGridSubset)item.getModelObject();
                GridSetBroker gridSetBroker = GWC.get().getGridSetBroker();
                String gridsetDescription = null;
                GridSet gridSet = gridSetBroker.get(gridSubset.getGridSetName());
                boolean bl = gridsetExists = gridSet != null;
                if (gridsetExists) {
                    gridsetLevels = gridSet.getNumLevels();
                    gridsetDescription = gridSet.getDescription();
                } else {
                    gridsetLevels = gridSubset.getZoomStop() == null ? 1 : gridSubset.getZoomStop();
                }
                Label gridSetLabel = new Label("gridSet", (IModel)new PropertyModel((Object)item.getModel(), "gridSetName"));
                if (!gridsetExists) {
                    gridSetLabel.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"gwc-missing-gridset"))});
                    this.getPage().warn((Serializable)((Object)("GridSet " + gridSubset.getGridSetName() + " does not exist")));
                }
                item.add(new Component[]{gridSetLabel});
                if (null != gridsetDescription) {
                    gridSetLabel.add(new Behavior[]{new AttributeModifier("title", (IModel)new Model((Serializable)((Object)gridsetDescription)))});
                }
                int maxZoomLevel = gridsetLevels - 1;
                ArrayList<Integer> zoomLevels = new ArrayList<Integer>(maxZoomLevel + 1);
                for (int z = 0; z <= maxZoomLevel; ++z) {
                    zoomLevels.add(z);
                }
                PropertyModel zoomStartModel = new PropertyModel((Object)item.getModel(), "zoomStart");
                PropertyModel zoomStopModel = new PropertyModel((Object)item.getModel(), "zoomStop");
                PropertyModel minCachedLevelModel = new PropertyModel((Object)item.getModel(), "minCachedLevel");
                PropertyModel maxCachedLevelModel = new PropertyModel((Object)item.getModel(), "maxCachedLevel");
                Model allLevels = new Model(zoomLevels);
                final ZoomLevelDropDownChoice zoomStart = new ZoomLevelDropDownChoice("zoomStart", (IModel<Integer>)zoomStartModel, (IModel<List<Integer>>)allLevels);
                zoomStart.setEnabled(gridsetExists);
                item.add(new Component[]{zoomStart});
                final ZoomLevelDropDownChoice zoomStop = new ZoomLevelDropDownChoice("zoomStop", (IModel<Integer>)zoomStopModel, (IModel<List<Integer>>)allLevels);
                zoomStop.setEnabled(gridsetExists);
                item.add(new Component[]{zoomStop});
                final ZoomLevelDropDownChoice minCachedLevel = new ZoomLevelDropDownChoice("minCachedLevel", (IModel<Integer>)minCachedLevelModel, (IModel<List<Integer>>)allLevels);
                minCachedLevel.setEnabled(gridsetExists);
                item.add(new Component[]{minCachedLevel});
                final ZoomLevelDropDownChoice maxCachedLevel = new ZoomLevelDropDownChoice("maxCachedLevel", (IModel<Integer>)maxCachedLevelModel, (IModel<List<Integer>>)allLevels);
                maxCachedLevel.setEnabled(gridsetExists);
                item.add(new Component[]{maxCachedLevel});
                for (ZoomLevelDropDownChoice dropDown : Arrays.asList(zoomStart, zoomStop, minCachedLevel, maxCachedLevel)) {
                    dropDown.add(new Behavior[]{new OnChangeAjaxBehavior(){
                        private static final long serialVersionUID = 1L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            GridSubsetsEditor.this.updateValidZoomRanges(zoomStart, zoomStop, minCachedLevel, maxCachedLevel, target);
                        }
                    }});
                }
                GridSubsetsEditor.this.updateValidZoomRanges(zoomStart, zoomStop, minCachedLevel, maxCachedLevel, null);
                Label gridSetBounds = Objects.nonNull(((XMLGridSubset)item.getModelObject()).getExtent()) ? new Label("bounds", (IModel)new PropertyModel((Object)item.getModel(), "extent")) : new Label("bounds", (IModel)new ResourceModel("GridSubsetsEditor.bounds.dynamic"));
                item.add(new Component[]{gridSetBounds});
                ImageAjaxLink<Object> removeLink = new ImageAjaxLink<Object>("removeLink", GWCIconFactory.DELETE_ICON){
                    private static final long serialVersionUID = -5072597940769821889L;

                    protected void onClick(AjaxRequestTarget target) {
                        ArrayList list = new ArrayList(GridSubsetsEditor.this.grids.getModelObject());
                        XMLGridSubset subset = (XMLGridSubset)this.getDefaultModelObject();
                        list.remove(subset);
                        GridSubsetsEditor.this.grids.setModelObject(list);
                        ArrayList<String> choices = new ArrayList<String>(GridSubsetsEditor.this.availableGridSets.getChoices());
                        choices.add(subset.getGridSetName());
                        Collections.sort(choices);
                        GridSubsetsEditor.this.availableGridSets.setChoices(choices);
                        target.add(new Component[]{container});
                        target.add(new Component[]{GridSubsetsEditor.this.availableGridSets});
                    }
                };
                removeLink.setDefaultModel(item.getModel());
                removeLink.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("GridSubsetsEditor.removeLink"))});
                item.add(new Component[]{removeLink});
            }
        };
        this.grids.setOutputMarkupId(true);
        this.grids.setReuseItems(true);
        this.table.add(new Component[]{this.grids});
        ArrayList gridSetNames = new ArrayList(GWC.get().getGridSetBroker().getNames());
        for (XMLGridSubset gs : (Set)model.getObject()) {
            gridSetNames.remove(gs.getGridSetName());
        }
        Collections.sort(gridSetNames);
        GeoServerAjaxFormLink addGridsubsetLink = new GeoServerAjaxFormLink("addGridSubset"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                GridSubsetsEditor.this.availableGridSets.processInput();
                String selectedGridset = (String)GridSubsetsEditor.this.availableGridSets.getModelObject();
                if (null == selectedGridset) {
                    return;
                }
                ArrayList choices = new ArrayList(GridSubsetsEditor.this.availableGridSets.getChoices());
                choices.remove(selectedGridset);
                GridSubsetsEditor.this.availableGridSets.setChoices(choices);
                GridSubsetsEditor.this.availableGridSets.setEnabled(!choices.isEmpty());
                XMLGridSubset newSubset = new XMLGridSubset();
                newSubset.setGridSetName(selectedGridset);
                GridSubsetsEditor.this.grids.getModelObject().add(newSubset);
                target.add(new Component[]{GridSubsetsEditor.this.table});
                target.add(new Component[]{GridSubsetsEditor.this.availableGridSets});
            }
        };
        addGridsubsetLink.add(new Component[]{new Icon("addIcon", GWCIconFactory.ADD_ICON)});
        this.add(new Component[]{addGridsubsetLink});
        this.availableGridSets = new Select2DropDownChoice("availableGridsets", (IModel)new Model(), gridSetNames);
        this.availableGridSets.setOutputMarkupId(true);
        this.add(new Component[]{this.availableGridSets});
    }

    public void convertInput() {
        this.grids.visitChildren((component, visit) -> {
            if (component instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)component;
                formComponent.processInput();
            }
        });
        List info = this.grids.getModelObject();
        HashSet convertedInput = new HashSet(info);
        this.setConvertedInput(convertedInput);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }

    public void setValidating(boolean validate) {
        this.validator.setEnabled(validate);
    }

    private void updateValidZoomRanges(ZoomLevelDropDownChoice zoomStart, ZoomLevelDropDownChoice zoomStop, ZoomLevelDropDownChoice minCachedLevel, ZoomLevelDropDownChoice maxCachedLevel, AjaxRequestTarget target) {
        Integer minCached;
        Integer max;
        Integer min = (Integer)zoomStart.getModelObject();
        if (min != null) {
            zoomStop.setAllowedMin(min);
            minCachedLevel.setAllowedMin(min);
            maxCachedLevel.setAllowedMin(min);
        }
        if ((max = (Integer)zoomStop.getModelObject()) != null) {
            minCachedLevel.setAllowedMax(max);
            maxCachedLevel.setAllowedMax(max);
        }
        if ((minCached = (Integer)minCachedLevel.getModelObject()) != null) {
            maxCachedLevel.setAllowedMin(minCached);
        }
        if (null != target) {
            target.add(new Component[]{zoomStop});
            target.add(new Component[]{minCachedLevel});
            target.add(new Component[]{maxCachedLevel});
        }
    }

    private class GridSubsetListValidator
    implements IValidator<Set<XMLGridSubset>> {
        private static final long serialVersionUID = -2646310164736911748L;
        private boolean validate;

        public GridSubsetListValidator() {
            this.setEnabled(true);
        }

        public void validate(IValidatable<Set<XMLGridSubset>> validatable) {
            if (!this.validate) {
                return;
            }
            Set gridSubsets = (Set)validatable.getValue();
            if (gridSubsets == null || gridSubsets.isEmpty()) {
                this.error(validatable, "GridSubsetsEditor.validation.empty", new String[0]);
                return;
            }
            GWC gwc = GWC.get();
            for (XMLGridSubset subset : gridSubsets) {
                BoundingBox fullBounds;
                boolean intersects;
                String gridSetName = subset.getGridSetName();
                Integer zoomStart = subset.getZoomStart();
                Integer zoomStop = subset.getZoomStop();
                BoundingBox extent = subset.getExtent();
                if (gridSetName == null) {
                    throw new IllegalStateException("GridSet name is null");
                }
                if (zoomStart != null && zoomStop != null && zoomStart > zoomStop) {
                    this.error(validatable, "GridSubsetsEditor.validation.zoomLevelsError", new String[0]);
                    return;
                }
                GridSetBroker gridSetBroker = gwc.getGridSetBroker();
                GridSet gridSet = gridSetBroker.get(gridSetName);
                if (null == gridSet) {
                    this.error(validatable, "GridSubsetsEditor.validation.gridSetNotFound", gridSetName);
                    return;
                }
                if (extent == null) continue;
                if (extent.isNull() || !extent.isSane()) {
                    this.error(validatable, "GridSubsetsEditor.validation.invalidBounds", new String[0]);
                }
                if (intersects = (fullBounds = gridSet.getOriginalExtent()).intersects(extent)) continue;
                this.error(validatable, "GridSubsetsEditor.validation.boundsOutsideCoverage", new String[0]);
            }
        }

        private void error(IValidatable<Set<XMLGridSubset>> validatable, String resourceKey, String ... params) {
            ValidationError error = new ValidationError();
            String message = params == null ? new ResourceModel(resourceKey).getObject() : (String)new ParamResourceModel(resourceKey, (Component)GridSubsetsEditor.this, (Object[])params).getObject();
            error.setMessage(message);
            validatable.error((IValidationError)error);
        }

        public void setEnabled(boolean validate) {
            this.validate = validate;
        }
    }

    private static class ZoomLevelDropDownChoice
    extends DropDownChoice<Integer> {
        private static final long serialVersionUID = -1312406093015271637L;

        public ZoomLevelDropDownChoice(String id, IModel<Integer> model, IModel<List<Integer>> allChoices) {
            super(id, model, allChoices);
            this.setNullValid(true);
            this.setOutputMarkupId(true);
        }

        protected String getNullValidKey() {
            String nullValidKey = "GridSubsetsEditor." + this.getId() + ".nullValid";
            return nullValidKey;
        }

        public void setAllowedMin(int newMin) {
            List choices = this.getChoices();
            int max = (Integer)choices.get(choices.size() - 1);
            this.setChoices(newMin, Math.max(newMin, max));
        }

        public void setAllowedMax(int max) {
            List choices = this.getChoices();
            int min = (Integer)choices.get(0);
            this.setChoices(Math.min(min, max), max);
        }

        private void setChoices(int min, int max) {
            ArrayList<Integer> choices = new ArrayList<Integer>();
            for (int i = min; i <= max; ++i) {
                choices.add(i);
            }
            Integer modelObject = (Integer)this.getModelObject();
            this.setChoices(choices);
            if (modelObject != null && modelObject >= min && modelObject <= max) {
                this.setModelObject(modelObject);
            } else {
                this.setModelObject(null);
            }
        }
    }
}

