/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.layer.ConfigureCachedLayerAjaxLink;
import org.geoserver.gwc.web.layer.UnconfiguredCachedLayersProvider;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.CachingImage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geowebcache.layer.TileLayer;

public class NewCachedLayerPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 6458510742445385219L;
    private UnconfiguredCachedLayersProvider provider = new UnconfiguredCachedLayersProvider();
    private GeoServerTablePanel<TileLayer> table = new GeoServerTablePanel<TileLayer>("table", (GeoServerDataProvider)this.provider, true){
        private static final long serialVersionUID = -5260899839139961722L;

        protected Component getComponentForProperty(String id, IModel<TileLayer> itemModel, GeoServerDataProvider.Property<TileLayer> property) {
            if (property == UnconfiguredCachedLayersProvider.TYPE) {
                Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)NewCachedLayerPage.this);
                TileLayer layer = (TileLayer)itemModel.getObject();
                PackageResourceReference layerIcon = GWCIconFactory.getSpecificLayerIcon(layer);
                f.add(new Component[]{new CachingImage("layerIcon", (ResourceReference)layerIcon, new ResourceReference[0])});
                return f;
            }
            if (property == UnconfiguredCachedLayersProvider.NAME) {
                return NewCachedLayerPage.this.nameLink(id, itemModel);
            }
            if (property == UnconfiguredCachedLayersProvider.ENABLED) {
                TileLayer layerInfo = (TileLayer)itemModel.getObject();
                boolean enabled = layerInfo.isEnabled();
                PackageResourceReference icon = enabled ? GWCIconFactory.getEnabledIcon() : GWCIconFactory.getDisabledIcon();
                Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)NewCachedLayerPage.this);
                f.add(new Component[]{new CachingImage("layerIcon", (ResourceReference)icon, new ResourceReference[0])});
                return f;
            }
            throw new IllegalArgumentException("Don't know a property named " + property.getName());
        }

        protected void onSelectionUpdate(AjaxRequestTarget target) {
            NewCachedLayerPage.this.updateBulkConfigLink();
            target.add(new Component[]{NewCachedLayerPage.this.bulkConfig});
        }
    };
    private GeoServerDialog dialog;
    private BulkCachedLayerConfigurationLink bulkConfig;
    private Label insaneDefaultsMessage;

    public NewCachedLayerPage() {
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setInitialWidth(360);
        this.dialog.setInitialHeight(180);
        this.setHeaderPanel(this.headerPanel());
    }

    private void updateBulkConfigLink() {
        int numSelected = this.table.getNumSelected();
        GWCConfig defaults = GWC.get().getConfig();
        boolean defaultsSane = defaults.isSane();
        this.bulkConfig.setEnabled(defaultsSane && numSelected > 0);
        this.insaneDefaultsMessage.setVisible(!defaultsSane);
    }

    private Component nameLink(String id, IModel<TileLayer> itemModel) {
        ConfigureCachedLayerAjaxLink link = new ConfigureCachedLayerAjaxLink(id, itemModel, NewCachedLayerPage.class);
        return link;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        Component[] componentArray = new Component[1];
        this.bulkConfig = new BulkCachedLayerConfigurationLink("bulkConfig");
        componentArray[0] = this.bulkConfig;
        header.add(componentArray);
        this.bulkConfig.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.insaneDefaultsMessage = new Label("insaneDefaultsMessage", (IModel)new ResourceModel("bulkConfig.insaneDefaults"));
        componentArray2[0] = this.insaneDefaultsMessage;
        header.add(componentArray2);
        this.insaneDefaultsMessage.setOutputMarkupId(true);
        this.updateBulkConfigLink();
        return header;
    }

    private class BulkCachedLayerConfigurationLink
    extends AjaxLink<String> {
        private static final long serialVersionUID = 1L;

        public BulkCachedLayerConfigurationLink(String string) {
            super(string, (IModel)new ResourceModel("NewCachedLayerPage.bulkConfig"));
        }

        public void onClick(AjaxRequestTarget target) {
            List selection = NewCachedLayerPage.this.table.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            final ArrayList<String> selectedNames = new ArrayList<String>();
            for (TileLayer layer : selection) {
                selectedNames.add(layer.getName());
            }
            NewCachedLayerPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmBulkConfig.title", (Component)NewCachedLayerPage.this, new Object[0]));
            NewCachedLayerPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                private static final long serialVersionUID = 1L;

                protected Component getContents(String id) {
                    Integer selectedLayerCount = selectedNames.size();
                    StringResourceModel model = new StringResourceModel("NewCachedLayerPage.confirmBulkConfig.message", (Component)BulkCachedLayerConfigurationLink.this).setParameters(new Object[]{selectedLayerCount.toString()});
                    Label confirmLabel = new Label(id, (IModel)model);
                    confirmLabel.setEscapeModelStrings(false);
                    return confirmLabel;
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    GWC facade = GWC.get();
                    GWCConfig saneConfig = facade.getConfig().saneConfig();
                    saneConfig.setCacheLayersByDefault(true);
                    facade.autoConfigureLayers(selectedNames, saneConfig);
                    NewCachedLayerPage.this.table.clearSelection();
                    return true;
                }

                public void onClose(AjaxRequestTarget target) {
                    List selection = NewCachedLayerPage.this.table.getSelection();
                    if (selection.isEmpty()) {
                        NewCachedLayerPage.this.updateBulkConfigLink();
                        target.add(new Component[]{BulkCachedLayerConfigurationLink.this});
                        target.add(new Component[]{NewCachedLayerPage.this.table});
                    }
                }
            });
        }
    }
}

