/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.mosaic;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.mosaic.MosaicType;
import org.eclipse.imagen.media.range.Range;

public class MosaicDescriptor
extends OperationDescriptorImpl {
    public static final MosaicType MOSAIC_TYPE_BLEND = new MosaicType("MOSAIC_TYPE_BLEND", 1);
    public static final MosaicType MOSAIC_TYPE_OVERLAY = new MosaicType("MOSAIC_TYPE_OVERLAY", 0);
    private static final long serialVersionUID = 2718297230579888333L;
    private static final String[][] resources = new String[][]{{"GlobalName", "Mosaic"}, {"LocalName", "Mosaic"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "A different mosaic operation which supports noData and doesn't supports threshold"}, {"DocURL", "wiki github non already available"}, {"Version", "1.0"}, {"arg0Desc", "Mosaic Type"}, {"arg1Desc", "The source Alpha bands"}, {"arg2Desc", "The source ROIs"}, {"arg3Desc", "Thresholds used for the mosaic"}, {"arg4Desc", "Background values"}, {"arg5Desc", "No data  Values"}};
    private static final Class[] paramClasses = new Class[]{MosaicType.class, PlanarImage[].class, ROI[].class, double[][].class, double[].class, Range[].class};
    private static final String[] paramNames = new String[]{"mosaicType", "sourceAlpha", "sourceROI", "sourceThreshold", "backgroundValues", "nodata"};
    private static final Object[] paramDefaults = new Object[]{MOSAIC_TYPE_OVERLAY, null, null, new double[][]{{1.0}}, new double[]{0.0}, null};

    public MosaicDescriptor() {
        super(resources, new String[]{"rendered"}, 0, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public static RenderedOp create(RenderedImage[] sources, MosaicType mosaicType, PlanarImage[] sourceAlpha, ROI[] sourceROI, double[][] sourceThreshold, double[] backgroundValues, Range[] nodata, RenderingHints renderingHints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Mosaic", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            pb.addSource((Object)sources[i]);
        }
        pb.setParameter("mosaicType", (Object)mosaicType);
        pb.setParameter("sourceAlpha", (Object)sourceAlpha);
        pb.setParameter("sourceROI", (Object)sourceROI);
        pb.setParameter("sourceThreshold", (Object)sourceThreshold);
        pb.setParameter("backgroundValues", (Object)backgroundValues);
        pb.setParameter("nodata", (Object)nodata);
        return ImageN.create((String)"Mosaic", (ParameterBlock)pb, (RenderingHints)renderingHints);
    }
}

