/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.mosaic;

import java.awt.Rectangle;
import org.eclipse.imagen.RasterAccessor;

abstract class PixelIterator {
    protected final RasterAccessor rasterAccessor;
    protected final int bands;
    private final int sourceMinX;
    private final int sourceMinY;
    private final int sourceMaxX;
    private final int sourceMaxY;
    private final int destMinX;
    private final int[] lineOffsets;
    protected final int[] pixelOffsets;
    private final int pixelStride;
    private final int lineStride;
    protected int x;
    protected int y;
    private final boolean overlap;
    private boolean hasData;
    private boolean hasDataY;

    public PixelIterator(Rectangle sourceRect, Rectangle destRect, RasterAccessor rasterAccessor) {
        this.rasterAccessor = rasterAccessor;
        this.lineStride = rasterAccessor.getScanlineStride();
        this.pixelStride = rasterAccessor.getPixelStride();
        int[] bandOffsets = rasterAccessor.getBandOffsets();
        this.bands = bandOffsets.length;
        this.lineOffsets = new int[this.bands];
        this.pixelOffsets = new int[this.bands];
        for (int b = 0; b < this.bands; ++b) {
            this.pixelOffsets[b] = bandOffsets[b];
            this.lineOffsets[b] = bandOffsets[b] + this.lineStride;
        }
        this.overlap = sourceRect.equals(destRect);
        this.hasDataY = this.overlap || sourceRect.y == destRect.y;
        this.hasData = this.overlap || sourceRect.x == destRect.x && this.hasDataY;
        this.x = destRect.x;
        this.y = destRect.y;
        this.sourceMinX = sourceRect.x;
        this.sourceMinY = sourceRect.y;
        this.sourceMaxX = sourceRect.x + sourceRect.width;
        this.sourceMaxY = sourceRect.y + sourceRect.height;
        this.destMinX = destRect.x;
    }

    public final void nextPixel() {
        ++this.x;
        if (this.hasData) {
            int b = 0;
            while (b < this.pixelOffsets.length) {
                int n = b++;
                this.pixelOffsets[n] = this.pixelOffsets[n] + this.pixelStride;
            }
        }
        this.hasData = this.overlap || this.hasDataY && this.x >= this.sourceMinX && this.x < this.sourceMaxX;
    }

    public final void nextLine() {
        ++this.y;
        this.x = this.destMinX;
        if (this.y > this.sourceMinY) {
            int b = 0;
            while (b < this.lineOffsets.length) {
                this.pixelOffsets[b] = this.lineOffsets[b];
                int n = b++;
                this.lineOffsets[n] = this.lineOffsets[n] + this.lineStride;
            }
        }
        this.hasDataY = this.overlap || this.y >= this.sourceMinY && this.y < this.sourceMaxY;
        this.hasData = this.overlap || this.hasDataY && this.x >= this.sourceMinX && this.x < this.sourceMaxX;
    }

    public final boolean hasData() {
        return this.hasData;
    }

    public final boolean isDone() {
        return this.y >= this.sourceMaxY || this.y == this.sourceMaxY - 1 && this.x >= this.sourceMaxX;
    }

    public static final class PixelIteratorDouble
    extends PixelIterator {
        private double[][] data;
        private final double[] pixel;

        public PixelIteratorDouble(Rectangle sourceRect, Rectangle destRect, RasterAccessor rasterAccessor) {
            super(sourceRect, destRect, rasterAccessor);
            this.pixel = new double[this.bands];
        }

        public double[] read() {
            double[][] data = this.getData();
            for (int b = 0; b < this.pixel.length; ++b) {
                this.pixel[b] = data[b][this.pixelOffsets[b]];
            }
            return this.pixel;
        }

        public double readOne() {
            double[][] data = this.getData();
            return data[0][this.pixelOffsets[0]];
        }

        private double[][] getData() {
            if (this.data == null) {
                this.data = this.rasterAccessor.getDoubleDataArrays();
            }
            return this.data;
        }
    }

    public static final class PixelIteratorFloat
    extends PixelIterator {
        private float[][] data;
        private final float[] pixel;

        public PixelIteratorFloat(Rectangle sourceRect, Rectangle destRect, RasterAccessor rasterAccessor) {
            super(sourceRect, destRect, rasterAccessor);
            this.pixel = new float[this.bands];
        }

        public float[] read() {
            float[][] data = this.getData();
            for (int b = 0; b < this.pixel.length; ++b) {
                this.pixel[b] = data[b][this.pixelOffsets[b]];
            }
            return this.pixel;
        }

        public float readOne() {
            float[][] data = this.getData();
            return data[0][this.pixelOffsets[0]];
        }

        private float[][] getData() {
            if (this.data == null) {
                this.data = this.rasterAccessor.getFloatDataArrays();
            }
            return this.data;
        }
    }

    public static final class PixelIteratorInt
    extends PixelIterator {
        private int[][] data;
        private final int[] pixel;

        public PixelIteratorInt(Rectangle sourceRect, Rectangle destRect, RasterAccessor rasterAccessor) {
            super(sourceRect, destRect, rasterAccessor);
            this.pixel = new int[this.bands];
        }

        public int[] read() {
            int[][] data = this.getData();
            for (int b = 0; b < this.pixel.length; ++b) {
                this.pixel[b] = data[b][this.pixelOffsets[b]];
            }
            return this.pixel;
        }

        public int readOne() {
            int[][] data = this.getData();
            return data[0][this.pixelOffsets[0]];
        }

        private int[][] getData() {
            if (this.data == null) {
                this.data = this.rasterAccessor.getIntDataArrays();
            }
            return this.data;
        }
    }

    public static final class PixelIteratorShort
    extends PixelIterator {
        private short[][] data;
        private final short[] pixel;

        public PixelIteratorShort(Rectangle sourceRect, Rectangle destRect, RasterAccessor rasterAccessor) {
            super(sourceRect, destRect, rasterAccessor);
            this.pixel = new short[this.bands];
        }

        public short[] read() {
            short[][] data = this.getData();
            for (int b = 0; b < this.pixel.length; ++b) {
                this.pixel[b] = data[b][this.pixelOffsets[b]];
            }
            return this.pixel;
        }

        public short readOne() {
            short[][] data = this.getData();
            return data[0][this.pixelOffsets[0]];
        }

        private short[][] getData() {
            if (this.data == null) {
                this.data = this.rasterAccessor.getShortDataArrays();
            }
            return this.data;
        }
    }

    public static final class PixelIteratorByte
    extends PixelIterator {
        private byte[][] data;
        private final byte[] pixel;

        public PixelIteratorByte(Rectangle sourceRect, Rectangle destRect, RasterAccessor rasterAccessor) {
            super(sourceRect, destRect, rasterAccessor);
            this.pixel = new byte[this.bands];
        }

        public byte[] read() {
            byte[][] data = this.getData();
            for (int b = 0; b < this.pixel.length; ++b) {
                this.pixel[b] = data[b][this.pixelOffsets[b]];
            }
            return this.pixel;
        }

        public byte readOne() {
            byte[][] data = this.getData();
            return data[0][this.pixelOffsets[0]];
        }

        private byte[][] getData() {
            if (this.data == null) {
                this.data = this.rasterAccessor.getByteDataArrays();
            }
            return this.data;
        }
    }
}

