/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.data.resource.LocalesDropdown;
import org.geoserver.web.data.resource.TitleAndAbstractPanel;
import org.geoserver.web.data.store.panel.FileModel;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.HTTPURLsListTextArea;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SRSListTextArea;
import org.geoserver.web.wicket.SimpleChoiceRenderer;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.web.ListModelCollection;
import org.geoserver.wms.web.MimeTypesFormComponent;
import org.geoserver.wms.web.publish.LayerAuthoritiesAndIdentifiersPanel;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;

public class WMSAdminPage
extends BaseServiceAdminPage<WMSInfo> {
    static final List<String> SVG_RENDERERS = Arrays.asList("Batik", "Simple");
    static final List<String> KML_REFLECTOR_MODES = Arrays.asList("refresh", "superoverlay", "download");
    static final List<String> KML_SUPEROVERLAY_MODES = Arrays.asList("auto", "raster", "overview", "hybrid", "cached");
    static final List<String> DISPOSAL_METHODS = new ArrayList<String>(Arrays.asList(WMS.DISPOSAL_METHODS));
    GSModalWindow modal;
    MimeTypesFormComponent getMapMimeTypesComponent;
    MimeTypesFormComponent getFeatureInfoMimeTypesComponent;
    TreeSet<String> getMapAvailable;
    TreeSet<String> getFeatureInfoAvailable;

    public WMSAdminPage() {
    }

    public WMSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    public WMSAdminPage(WMSInfo service) {
        super((ServiceInfo)service);
    }

    protected Class<WMSInfo> getServiceClass() {
        return WMSInfo.class;
    }

    protected void build(IModel info, Form form) {
        Component[] componentArray = new Component[1];
        this.modal = new GSModalWindow("modal");
        componentArray[0] = this.modal;
        form.add(componentArray);
        form.add(new Component[]{new TitleAndAbstractPanel("rootLayerTitleAndAbstract", info, "rootLayerTitle", "internationalRootLayerTitle", "rootLayerAbstract", "internationalRootLayerAbstract", "rootLayerTitle", "rootLayerAbstract", (MarkupContainer)this)});
        PropertyModel metadataModel = new PropertyModel((Object)info, "metadata");
        MapModel<Boolean> rootLayerEnabled = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Object)WMS.ROOT_LAYER_IN_CAPABILITIES_DEFAULT);
        CheckBox rootLayerEnabledField = new CheckBox("rootLayerEnabled", rootLayerEnabled);
        form.add(new Component[]{rootLayerEnabledField});
        LayerAuthoritiesAndIdentifiersPanel authAndIds = new LayerAuthoritiesAndIdentifiersPanel("authoritiesAndIds", true, (IModel<? extends CatalogInfo>)info);
        form.add(new Component[]{authAndIds});
        SRSListTextArea srsList = new SRSListTextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "sRS")));
        form.add(new Component[]{srsList});
        form.add(new Component[]{new CheckBox("bBOXForEachCRS")});
        form.add(new Component[]{new AjaxLink<Object>("bBOXForEachCRSHelp"){

            public void onClick(AjaxRequestTarget target) {
                WMSAdminPage.this.dialog.showInfo(target, (IModel)new StringResourceModel("bboxForEachCRSHelp.title", (Component)WMSAdminPage.this, null), new IModel[]{new StringResourceModel("bboxForEachCRSHelp.message", (Component)WMSAdminPage.this, null)});
            }
        }});
        MapModel<Boolean> aphEnabled = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, WMS.ADVANCED_PROJECTION_KEY, (Object)WMS.ENABLE_ADVANCED_PROJECTION);
        CheckBox aphEnabledField = new CheckBox("aph.enabled", aphEnabled);
        form.add(new Component[]{aphEnabledField});
        MapModel<Boolean> aphWrap = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, WMS.MAP_WRAPPING_KEY, (Object)WMS.ENABLE_MAP_WRAPPING);
        CheckBox aphWrapField = new CheckBox("aph.wrap", aphWrap);
        form.add(new Component[]{aphWrapField});
        MapModel<Boolean> aphDensify = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, WMS.ADVANCED_PROJECTION_DENSIFICATION_KEY, (Object)WMS.ENABLE_ADVANCED_PROJECTION_DENSIFICATION);
        CheckBox aphDensifyField = new CheckBox("aph.densify", aphDensify);
        form.add(new Component[]{aphDensifyField});
        MapModel<Boolean> aphHeuristic = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, WMS.DATELINE_WRAPPING_HEURISTIC_KEY, (Object)WMS.DISABLE_DATELINE_WRAPPING_HEURISTIC);
        CheckBox aphHeuristicField = new CheckBox("aph.dlh", aphHeuristic);
        form.add(new Component[]{aphHeuristicField});
        form.add(new Component[]{new DropDownChoice("interpolation", Arrays.asList(WMSInfo.WMSInterpolation.values()), (IChoiceRenderer)new InterpolationRenderer())});
        TextField maxMemory = new TextField("maxRequestMemory");
        maxMemory.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxMemory});
        TextField maxTime = new TextField("maxRenderingTime");
        maxTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxTime});
        TextField maxErrors = new TextField("maxRenderingErrors");
        maxErrors.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxErrors});
        TextField maxBuffer = new TextField("maxBuffer");
        maxBuffer.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxBuffer});
        List<Boolean> exceptionValues = Arrays.asList(Boolean.TRUE, Boolean.FALSE);
        DropDownChoice invalidDimensionThrow = new DropDownChoice("exceptionOnInvalidDimension", exceptionValues);
        invalidDimensionThrow.setChoiceRenderer((IChoiceRenderer)new ExceptionChoiceRenderer());
        invalidDimensionThrow.setNullValid(true);
        form.add(new Component[]{invalidDimensionThrow});
        TextField maxRequestedDimensionValues = new TextField("maxRequestedDimensionValues");
        maxRequestedDimensionValues.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxRequestedDimensionValues});
        form.add(new Component[]{new CheckBox("watermark.enabled")});
        TextField watermarkUrlField = new TextField("watermark.uRL", (IModel)new FileModel((IModel)new PropertyModel((Object)form.getModel(), "watermark.URL")));
        watermarkUrlField.add((IValidator)new FileExistsValidator(true));
        watermarkUrlField.setOutputMarkupId(true);
        form.add(new Component[]{watermarkUrlField});
        form.add(new Component[]{this.chooserButton("chooser", new ParamResourceModel("chooseWatermark", (Component)this, new Object[0]).getString(), (TextField<String>)watermarkUrlField)});
        TextField transparency = new TextField("watermark.transparency");
        transparency.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{transparency});
        form.add(new Component[]{new DropDownChoice("watermark.position", Arrays.asList(WatermarkInfo.Position.values()), (IChoiceRenderer)new WatermarkPositionRenderer())});
        form.add(new Component[]{new CheckBox("svg.antialias", (IModel)new MapModel((IModel)metadataModel, "svgAntiAlias"))});
        form.add(new Component[]{new DropDownChoice("svg.producer", (IModel)new MapModel((IModel)metadataModel, "svgRenderer"), SVG_RENDERERS, (IChoiceRenderer)new SVGMethodRenderer())});
        MapModel<Integer> pngCompression = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "pngCompression", 25);
        TextField pngCompressionField = new TextField("png.compression", pngCompression, Integer.class);
        pngCompressionField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{pngCompressionField});
        MapModel<Integer> jpegCompression = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "jpegCompression", 25);
        TextField jpegCompressionField = new TextField("jpeg.compression", jpegCompression, Integer.class);
        jpegCompressionField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{jpegCompressionField});
        MapModel<String> kmlReflectorMode = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, WMS.KML_REFLECTOR_MODE, (Object)"refresh");
        form.add(new Component[]{new DropDownChoice("kml.defaultReflectorMode", kmlReflectorMode, KML_REFLECTOR_MODES)});
        MapModel<String> kmlSuperoverlayMode = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "kmlSuperoverlayMode", (Object)"auto");
        form.add(new Component[]{new DropDownChoice("kml.superoverlayMode", kmlSuperoverlayMode, KML_SUPEROVERLAY_MODES)});
        form.add(new Component[]{new CheckBox("kml.kmattr", this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "kmlAttr", true))});
        form.add(new Component[]{new CheckBox("kml.kmlplacemark", this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "kmlPlacemark", false))});
        MapModel<Integer> kmScore = this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "kmlKmscore", 40);
        TextField kmScoreField = new TextField("kml.kmscore", kmScore, Integer.class);
        kmScoreField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{kmScoreField});
        form.add(new Component[]{new CheckBox("scalehint.mapunitsPixel", this.defaultedModel((IModel<Map<String, ?>>)metadataModel, "scalehintMapunitsPixel", (Object)WMS.SCALEHINT_MAPUNITS_PIXEL_DEFAULT))});
        this.getMapAvailable = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (GetMapOutputFormat format : GeoServerExtensions.extensions(GetMapOutputFormat.class)) {
            this.getMapAvailable.add(format.getMimeType());
        }
        ArrayList getMapSelected = new ArrayList();
        getMapSelected.addAll((Collection)new PropertyModel((Object)info, "getMapMimeTypes").getObject());
        ArrayList<String> getMapChoices = new ArrayList<String>();
        getMapChoices.addAll(this.getMapAvailable);
        Component[] componentArray2 = new Component[1];
        this.getMapMimeTypesComponent = new MimeTypesFormComponent("getMapMimeTypes", (IModel<List<String>>)new ListModel(getMapSelected), (IModel<Collection<String>>)new CollectionModel(getMapChoices), (Boolean)new PropertyModel((Object)info, "getMapMimeTypeCheckingEnabled").getObject());
        componentArray2[0] = this.getMapMimeTypesComponent;
        form.add(componentArray2);
        this.getFeatureInfoAvailable = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (GetFeatureInfoOutputFormat format : GeoServerExtensions.extensions(GetFeatureInfoOutputFormat.class)) {
            this.getFeatureInfoAvailable.add(format.getContentType());
        }
        ArrayList getFeatureInfoSelected = new ArrayList();
        getFeatureInfoSelected.addAll((Collection)new PropertyModel((Object)info, "getFeatureInfoMimeTypes").getObject());
        ArrayList<String> getFeatureInfoChoices = new ArrayList<String>();
        getFeatureInfoChoices.addAll(this.getFeatureInfoAvailable);
        Component[] componentArray3 = new Component[1];
        this.getFeatureInfoMimeTypesComponent = new MimeTypesFormComponent("getFeatureInfoMimeTypes", (IModel<List<String>>)new ListModel(getFeatureInfoSelected), (IModel<Collection<String>>)new CollectionModel(getFeatureInfoChoices), (Boolean)new PropertyModel((Object)info, "getFeatureInfoMimeTypeCheckingEnabled").getObject());
        componentArray3[0] = this.getFeatureInfoMimeTypesComponent;
        form.add(componentArray3);
        form.add(new Component[]{new CheckBox("dynamicStyling.disabled", (IModel)new PropertyModel((Object)info, "dynamicStylingDisabled"))});
        form.add(new Component[]{new CheckBox("disableFeaturesReproject", (IModel)new PropertyModel((Object)info, "featuresReprojectionDisabled"))});
        form.add(new Component[]{new CheckBox("disableTransformFeatureInfo", (IModel)new PropertyModel((Object)info, "transformFeatureInfoDisabled"))});
        form.add(new Component[]{new CheckBox("autoEscapeTemplateValues", (IModel)new PropertyModel((Object)info, "autoEscapeTemplateValues"))});
        TextField cacheMaxExtries = new TextField("cacheConfiguration.maxEntries");
        cacheMaxExtries.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{cacheMaxExtries});
        TextField cacheEntrySize = new TextField("cacheConfiguration.maxEntrySize");
        cacheEntrySize.add((IValidator)new RangeValidator((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        form.add(new Component[]{cacheEntrySize});
        form.add(new Component[]{new CheckBox("cacheConfiguration.enabled")});
        TextField remoteStylesTimeout = new TextField("remoteStyleTimeout");
        remoteStylesTimeout.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{remoteStylesTimeout});
        TextField remoteStylesMaxRequestTime = new TextField("remoteStyleMaxRequestTime");
        remoteStylesMaxRequestTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{remoteStylesMaxRequestTime});
        HTTPURLsListTextArea allowedRemoteSLDUrlsForAuthorizationForwarding = new HTTPURLsListTextArea("allowedURLsForAuthForwarding", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "allowedURLsForAuthForwarding")));
        form.add(new Component[]{allowedRemoteSLDUrlsForAuthorizationForwarding});
        form.add(new Component[]{new CheckBox("defaultGroupStyleEnabled")});
        form.add(new Component[]{new LocalesDropdown("defaultLocale", (IModel)new PropertyModel((Object)info, "defaultLocale"))});
        this.addMarkFactoryLoadOptimizationPanel(metadataModel, form);
    }

    private void addMarkFactoryLoadOptimizationPanel(PropertyModel<Map<String, ?>> metadataModel, Form<?> form) {
        this.checkAndInitializeMapData(metadataModel);
        MapModel mapMarkFactoryList = new MapModel(metadataModel, "MarkFactoryList");
        final IModel<List<String>> markFactoryList = this.buildMarkFactoryListModel((MapModel<String>)mapMarkFactoryList);
        final ListModelCollection liveCollection = new ListModelCollection(markFactoryList);
        if (mapMarkFactoryList.getObject() == null) {
            mapMarkFactoryList.setObject((Object)"");
        }
        IModel<Collection<String>> collectionModel = new IModel<Collection<String>>(){

            public void setObject(Collection<String> object) {
                markFactoryList.setObject(new ArrayList<String>(object));
            }

            public Collection<String> getObject() {
                return liveCollection;
            }
        };
        LiveCollectionModel markFactoriesLiveCollectionModel = LiveCollectionModel.list((IModel)collectionModel);
        Palette<String> factoriesSetupPallete = this.buildMarkFactoryPalleteComponent((LiveCollectionModel<String, List<String>>)markFactoriesLiveCollectionModel);
        factoriesSetupPallete.setOutputMarkupPlaceholderTag(true);
        factoriesSetupPallete.add(new Behavior[]{new DefaultTheme()});
        form.add(new Component[]{factoriesSetupPallete});
        final IModel<Boolean> enableModel = this.buildEnableModel((LiveCollectionModel<String, List<String>>)markFactoriesLiveCollectionModel);
        Label label = new Label("enableMarkFactoryLabel", (Serializable)((Object)new ResourceModel("WMSAdminPage.markFactorySetup").getObject())){

            public boolean isVisible() {
                return (Boolean)enableModel.getObject();
            }
        };
        label.setOutputMarkupId(true);
        label.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{label});
        AjaxCheckBox enableCheckBox = this.buildMarkFactoryEnableCheck(label, factoriesSetupPallete, enableModel);
        enableCheckBox.setOutputMarkupId(true);
        form.add(new Component[]{enableCheckBox});
    }

    private IModel<List<String>> buildMarkFactoryListModel(final MapModel<String> mapMarkFactoryList) {
        return new IModel<List<String>>(){

            public List<String> getObject() {
                String value = (String)mapMarkFactoryList.getObject();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    return new ArrayList<String>(Arrays.asList(value.split(",")));
                }
                return new ArrayList<String>();
            }

            public void setObject(List<String> object) {
                if (object == null) {
                    mapMarkFactoryList.setObject((Object)"");
                    return;
                }
                StringBuilder builder = new StringBuilder();
                boolean started = false;
                for (String value : object) {
                    if (started) {
                        builder.append(",");
                    }
                    builder.append(value);
                    started = true;
                }
                mapMarkFactoryList.setObject((Object)builder.toString());
            }
        };
    }

    private AjaxCheckBox buildMarkFactoryEnableCheck(final Label label, final Palette<String> factoriesSetupPallete, final IModel<Boolean> enableModel) {
        return new AjaxCheckBox("enableMarkFactory", enableModel){

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)enableModel.getObject()).booleanValue()) {
                    factoriesSetupPallete.setVisible(true);
                } else {
                    factoriesSetupPallete.setVisible(false);
                }
                target.add(new Component[]{factoriesSetupPallete});
                target.add(new Component[]{label});
            }
        };
    }

    private IModel<Boolean> buildEnableModel(final LiveCollectionModel<String, List<String>> markFactoriesLiveCollectionModel) {
        return new IModel<Boolean>(){

            public void setObject(Boolean object) {
                if (Boolean.TRUE.equals(object)) {
                    ArrayList<String> identifiers = new ArrayList<String>(WMSAdminPage.getMarkFactoryModelsIdentifiers());
                    markFactoriesLiveCollectionModel.setObject(identifiers);
                } else {
                    markFactoriesLiveCollectionModel.setObject(new ArrayList());
                }
            }

            public Boolean getObject() {
                return CollectionUtils.isNotEmpty((Collection)((Collection)markFactoriesLiveCollectionModel.getObject()));
            }
        };
    }

    private Palette<String> buildMarkFactoryPalleteComponent(final LiveCollectionModel<String, List<String>> markFactoriesLiveCollectionModel) {
        return new Palette<String>("MarkFactoryPalette", markFactoriesLiveCollectionModel, (IModel)new MarkFactoriesModel(), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, true){
            private static final long serialVersionUID = 1L;

            protected void onBeforeRender() {
                if (CollectionUtils.isEmpty((Collection)((Collection)markFactoriesLiveCollectionModel.getObject()))) {
                    this.setVisible(false);
                }
                super.onBeforeRender();
            }

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("MarkFactoryPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("MarkFactoryPalette.availableHeader"));
            }
        };
    }

    private void checkAndInitializeMapData(PropertyModel<Map<String, ?>> metadataModel) {
        PropertyModel<Map<String, ?>> mapModel = metadataModel;
        Object object = ((Map)mapModel.getObject()).get("MarkFactoryList");
        if (!(object instanceof String)) {
            ((Map)mapModel.getObject()).put("MarkFactoryList", "");
        }
    }

    private static List<String> getMarkFactoryModelsIdentifiers() {
        return IteratorUtils.toList((Iterator)DynamicSymbolFactoryFinder.getMarkFactories()).stream().map(mf -> mf.getClass().getSimpleName()).collect(Collectors.toList());
    }

    protected void handleSubmit(WMSInfo info) {
        info.setGetMapMimeTypeCheckingEnabled(this.getMapMimeTypesComponent.isMimeTypeCheckingEnabled());
        if (info.isGetMapMimeTypeCheckingEnabled()) {
            info.getGetMapMimeTypes().addAll(this.getMapMimeTypesComponent.getPalette().getModelCollection());
        } else {
            info.getGetMapMimeTypes().clear();
        }
        info.setGetFeatureInfoMimeTypeCheckingEnabled(this.getFeatureInfoMimeTypesComponent.isMimeTypeCheckingEnabled());
        if (info.isGetFeatureInfoMimeTypeCheckingEnabled()) {
            info.getGetFeatureInfoMimeTypes().addAll(this.getFeatureInfoMimeTypesComponent.getPalette().getModelCollection());
        } else {
            info.getGetFeatureInfoMimeTypes().clear();
        }
        super.handleSubmit((ServiceInfo)info);
    }

    protected Component chooserButton(String linkId, final String windowTitle, final TextField<String> textField) {
        AjaxSubmitLink link = new AjaxSubmitLink(linkId){

            public boolean getDefaultFormProcessing() {
                return false;
            }

            public void onSubmit(AjaxRequestTarget target) {
                File file = null;
                textField.processInput();
                String input = (String)textField.getConvertedInput();
                if (input != null && !input.equals("")) {
                    file = new File(input);
                }
                GeoServerFileChooser chooser = new GeoServerFileChooser(WMSAdminPage.this.modal.getContentId(), (IModel)new Model((Serializable)file)){

                    protected void fileClicked(File file, Optional<AjaxRequestTarget> target) {
                        textField.clearInput();
                        textField.setModelObject((Object)file.getAbsolutePath());
                        if (target.isPresent()) {
                            target.get().add(new Component[]{textField});
                            WMSAdminPage.this.dialog.close(target.get());
                        }
                    }
                };
                chooser.setFileTableHeight(null);
                WMSAdminPage.this.modal.setContent((Component)chooser);
                WMSAdminPage.this.modal.setTitle(windowTitle);
                WMSAdminPage.this.modal.show(target);
            }
        };
        return link;
    }

    <T> MapModel<T> defaultedModel(IModel<Map<String, ?>> baseModel, String key, T defaultValue) {
        MapModel model = new MapModel(baseModel, key);
        if (model.getObject() == null) {
            model.setObject(defaultValue);
        }
        return model;
    }

    protected String getServiceName() {
        return "WMS";
    }

    protected boolean supportInternationalContent() {
        return true;
    }

    private class InterpolationRenderer
    extends ChoiceRenderer {
        private InterpolationRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WMSInfo.WMSInterpolation)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WMSInfo.WMSInterpolation)object).name();
        }
    }

    private class ExceptionChoiceRenderer
    extends ChoiceRenderer<Boolean> {
        private ExceptionChoiceRenderer() {
        }

        public Object getDisplayValue(Boolean object) {
            return new ParamResourceModel("exceptionOnInvalidDimension." + object, (Component)WMSAdminPage.this, new Object[0]).getString();
        }

        public String getIdValue(Boolean object, int index) {
            return String.valueOf(object);
        }
    }

    private class WatermarkPositionRenderer
    extends ChoiceRenderer {
        private WatermarkPositionRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WatermarkInfo.Position)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WatermarkInfo.Position)object).name();
        }
    }

    private class SVGMethodRenderer
    extends ChoiceRenderer {
        private SVGMethodRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel("svg." + String.valueOf(object), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return (String)object;
        }
    }

    private static class MarkFactoriesModel
    extends LoadableDetachableModel<List<String>> {
        private MarkFactoriesModel() {
        }

        protected List<String> load() {
            return WMSAdminPage.getMarkFactoryModelsIdentifiers();
        }
    }
}

