/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.ParamResourceModel;

class ChooseImagePanel
extends Panel {
    private static final long serialVersionUID = 7564545298131010218L;
    private WorkspaceInfo ws;
    private String[] extensions;

    public ChooseImagePanel(String id, WorkspaceInfo ws, String[] extensions) {
        super(id);
        this.ws = ws;
        this.extensions = extensions;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        TreeSet<String> imageSet = new TreeSet<String>();
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
        for (Resource r : dd.getStyles(this.ws, new String[0]).list()) {
            if (!ArrayUtils.contains((Object[])this.extensions, (Object)FilenameUtils.getExtension((String)r.name()).toLowerCase())) continue;
            imageSet.add(r.name());
        }
        final FileUploadField upload = new FileUploadField("upload", (IModel)new Model());
        final Model imageModel = new Model();
        final DropDownChoice image = new DropDownChoice("image", (IModel)imageModel, new ArrayList(imageSet));
        final Image display = new Image("display", (IResource)new ResourceStreamResource((IResourceStream)new AbstractResourceStream(){
            private static final long serialVersionUID = 9031811973994305485L;
            transient InputStream is;

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
                this.is = dd.getStyles(ChooseImagePanel.this.ws, new String[0]).get((String)((Object)imageModel.getObject())).in();
                return this.is;
            }

            public void close() throws IOException {
                if (this.is != null) {
                    this.is.close();
                }
            }
        }), new IResource[0]);
        display.setOutputMarkupPlaceholderTag(true).setVisible(false);
        image.setNullValid(true).setOutputMarkupId(true).add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 6320466559337730660L;

            protected void onUpdate(AjaxRequestTarget target) {
                upload.setModelObject(null);
                display.setVisible(image.getModelObject() != null);
                target.add(new Component[]{upload});
                target.add(new Component[]{display});
            }
        }});
        upload.setOutputMarkupId(true).add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 5905505859401520055L;

            protected void onUpdate(AjaxRequestTarget target) {
                image.setModelObject(null);
                display.setVisible(false);
                target.add(new Component[]{image});
                target.add(new Component[]{display});
            }
        }});
        this.add(new Component[]{image});
        this.add(new Component[]{display});
        this.add(new Component[]{upload});
        ((Form)this.findParent(Form.class)).add((IFormValidator)new AbstractFormValidator(){
            private static final long serialVersionUID = 1388363954282359884L;

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[]{image, upload};
            }

            public void validate(Form<?> form) {
                if (image.getConvertedInput() == null && (upload.getConvertedInput() == null || ((List)upload.getConvertedInput()).isEmpty())) {
                    form.error((Serializable)((Object)new ParamResourceModel("missingImage", (Component)ChooseImagePanel.this.getPage(), new Object[0]).getString()));
                }
            }
        });
    }

    public String getChoice() {
        return this.get("image").getDefaultModelObjectAsString();
    }

    public FileUpload getFileUpload() {
        return ((FileUploadField)this.get("upload")).getFileUpload();
    }

    public FeedbackPanel getFeedback() {
        return (FeedbackPanel)this.get("feedback");
    }
}

