/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.StyleEditTabPanel;

public class LayerAssociationPanel
extends StyleEditTabPanel {
    private static final long serialVersionUID = -59522993086560769L;

    protected Boolean usesEditedStyle(LayerInfo l) {
        for (StyleInfo s : l.getStyles()) {
            if (!s.getName().equals(this.getStylePage().getStyleInfo().getName())) continue;
            return true;
        }
        return false;
    }

    protected Boolean defaultEditedStyle(LayerInfo l) {
        StyleInfo s = l.getDefaultStyle();
        if (s != null) {
            return s.getName().equals(this.getStylePage().getStyleInfo().getName());
        }
        return false;
    }

    public LayerAssociationPanel(String id, final AbstractStylePage parent) {
        super(id, parent);
        final LayerProvider layerProvider = new LayerProvider();
        GeoServerTablePanel<LayerInfo> layerTable = new GeoServerTablePanel<LayerInfo>("layer.table", (GeoServerDataProvider)layerProvider){
            private static final long serialVersionUID = 6100831799966767858L;

            public Component getComponentForProperty(String id, IModel<LayerInfo> value, GeoServerDataProvider.Property<LayerInfo> property) {
                LayerInfo layer = (LayerInfo)value.getObject();
                String text = property.getPropertyValue((Object)layer).toString();
                if (property == layerProvider.defaultStyle) {
                    DefaultStyleModel model = new DefaultStyleModel(layer, parent);
                    Fragment fragment = new Fragment(id, "layer.default.checkbox", (MarkupContainer)LayerAssociationPanel.this);
                    fragment.add(new Component[]{new AjaxCheckBox("default.selected", model){
                        private static final long serialVersionUID = 3572882767660629935L;

                        public void onUpdate(AjaxRequestTarget target) {
                        }
                    }});
                    return fragment;
                }
                if (property == layerProvider.associatedStyle) {
                    AssociatedStyleModel model = new AssociatedStyleModel(layer, parent);
                    Fragment fragment = new Fragment(id, "layer.association.checkbox", (MarkupContainer)LayerAssociationPanel.this);
                    fragment.add(new Component[]{new AjaxCheckBox("association.selected", model){
                        private static final long serialVersionUID = 3572882767660629935L;

                        public void onUpdate(AjaxRequestTarget target) {
                        }
                    }});
                    return fragment;
                }
                return new Label(id, (Serializable)((Object)text));
            }
        };
        this.add(new Component[]{layerTable});
    }

    private class LayerProvider
    extends GeoServerDataProvider<LayerInfo> {
        private static final long serialVersionUID = -1800971869092748431L;
        GeoServerDataProvider.Property<LayerInfo> workspace = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Workspace"){
            private static final long serialVersionUID = -1851109132536014276L;

            public Object getPropertyValue(LayerInfo x) {
                return x.getResource().getStore().getWorkspace().getName();
            }
        };
        GeoServerDataProvider.Property<LayerInfo> layer = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Layer"){
            private static final long serialVersionUID = -1041914399204405146L;

            public Object getPropertyValue(LayerInfo x) {
                return x.getName();
            }
        };
        GeoServerDataProvider.Property<LayerInfo> defaultStyle = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Default"){

            public Object getPropertyValue(LayerInfo x) {
                return LayerAssociationPanel.this.defaultEditedStyle(x);
            }
        };
        GeoServerDataProvider.Property<LayerInfo> associatedStyle = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Associated"){
            private static final long serialVersionUID = 890930107903888545L;

            public Object getPropertyValue(LayerInfo x) {
                return LayerAssociationPanel.this.usesEditedStyle(x);
            }
        };

        private LayerProvider() {
        }

        public List<LayerInfo> getItems() {
            return LayerAssociationPanel.this.getStylePage().getCatalog().getLayers();
        }

        public List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
            return Arrays.asList(this.workspace, this.layer, this.defaultStyle, this.associatedStyle);
        }
    }

    private class AssociatedStyleModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = -5895600269146950033L;
        private final LayerInfo layer;
        private final AbstractStylePage parent;

        public AssociatedStyleModel(LayerInfo layer, AbstractStylePage parent) {
            this.layer = layer;
            this.parent = parent;
        }

        public Boolean getObject() {
            return LayerAssociationPanel.this.usesEditedStyle(this.layer);
        }

        public void setObject(Boolean b) {
            if (b.booleanValue()) {
                this.layer.getStyles().add(this.parent.getStyleInfo());
            } else {
                StyleInfo s = null;
                for (StyleInfo candidate : this.layer.getStyles()) {
                    if (!candidate.getName().equals(this.parent.getStyleInfo().getName())) continue;
                    s = candidate;
                    break;
                }
                if (s != null) {
                    this.layer.getStyles().remove(s);
                }
            }
            this.parent.getCatalog().save(this.layer);
        }
    }

    private class DefaultStyleModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = -5895600269146950033L;
        private final LayerInfo layer;
        private final AbstractStylePage parent;

        public DefaultStyleModel(LayerInfo layer, AbstractStylePage parent) {
            this.layer = layer;
            this.parent = parent;
        }

        public Boolean getObject() {
            return LayerAssociationPanel.this.defaultEditedStyle(this.layer);
        }

        public void setObject(Boolean b) {
            if (b.booleanValue()) {
                this.layer.setDefaultStyle(this.parent.getStyleInfo());
            } else if (this.layer.getStyles().isEmpty()) {
                this.layer.setDefaultStyle(this.parent.getCatalog().getStyleByName("generic"));
            } else {
                StyleInfo s = (StyleInfo)this.layer.getStyles().iterator().next();
                this.layer.setDefaultStyle(s);
            }
            this.parent.getCatalog().save(this.layer);
        }
    }
}

