/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.BandsPanel;
import org.geoserver.wms.web.data.DataPanel;
import org.geoserver.wms.web.data.LayerChooser;
import org.geoserver.wms.web.data.StyleEditTabPanel;
import org.geotools.util.logging.Logging;

public class LayerAttributePanel
extends StyleEditTabPanel {
    static final Logger LOGGER = Logging.getLogger(LayerAttributePanel.class);
    private static final long serialVersionUID = -5936224477909623317L;

    public LayerAttributePanel(String id, final AbstractStylePage parent) throws IOException {
        super(id, parent);
        PropertyModel layerNameModel = new PropertyModel(parent.getLayerModel(), "prefixedName");
        this.add(new Component[]{new SimpleAjaxLink<String>("changeLayer", (IModel)layerNameModel){
            private static final long serialVersionUID = 7341058018479354596L;

            public void onClick(AjaxRequestTarget target) {
                GSModalWindow popup = parent.getPopup();
                popup.setInitialHeight(400);
                popup.setInitialWidth(600);
                popup.setTitle((IModel)new Model((Serializable)((Object)"Choose layer to edit")));
                popup.setContent((Component)new LayerChooser(popup.getContentId(), parent));
                popup.show(target);
            }
        }});
        this.setDefaultModel(parent.getLayerModel());
        this.updateAttributePanel();
    }

    @Override
    protected void configurationChanged() {
        try {
            this.updateAttributePanel();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not update LayerAttributePanel", e);
        }
    }

    protected void updateAttributePanel() throws IOException {
        ResourceInfo resource = this.getStylePage().getLayerInfo().getResource();
        if (this.get("attributePanel") != null) {
            this.remove("attributePanel");
        }
        if (resource instanceof FeatureTypeInfo) {
            FeatureTypeInfo info1 = (FeatureTypeInfo)resource;
            this.add(new Component[]{new DataPanel("attributePanel", info1)});
        } else if (resource instanceof CoverageInfo) {
            CoverageInfo info = (CoverageInfo)resource;
            this.add(new Component[]{new BandsPanel("attributePanel", info)});
        }
    }
}

