/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.publish.PublishedConfigurationPanel;

public class AttributionLayerConfigPanel
extends PublishedConfigurationPanel<PublishedInfo> {
    private static final long serialVersionUID = -5229831547353122190L;

    public AttributionLayerConfigPanel(String id, IModel<? extends PublishedInfo> model) {
        super(id, model);
        PublishedInfo layer = (PublishedInfo)model.getObject();
        if (layer.getAttribution() == null) {
            layer.setAttribution(GeoServerApplication.get().getCatalog().getFactory().createAttribution());
        }
        this.add(new Component[]{new TextField("wms.attribution.title", (IModel)new PropertyModel(model, "attribution.title"))});
        TextField href = new TextField("wms.attribution.href", (IModel)new PropertyModel(model, "attribution.href"));
        href.add((IValidator)new UrlValidator());
        href.setOutputMarkupId(true);
        this.add(new Component[]{href});
        final TextField logo = new TextField("wms.attribution.logo", (IModel)new PropertyModel(model, "attribution.logoURL"));
        logo.add((IValidator)new UrlValidator());
        logo.setOutputMarkupId(true);
        this.add(new Component[]{logo});
        final TextField type = new TextField("wms.attribution.type", (IModel)new PropertyModel(model, "attribution.logoType"));
        type.setOutputMarkupId(true);
        this.add(new Component[]{type});
        final TextField height = new TextField("wms.attribution.height", (IModel)new PropertyModel(model, "attribution.logoHeight"), Integer.class);
        height.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        height.setOutputMarkupId(true);
        this.add(new Component[]{height});
        final TextField width = new TextField("wms.attribution.width", (IModel)new PropertyModel(model, "attribution.logoWidth"), Integer.class);
        width.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        width.setOutputMarkupId(true);
        this.add(new Component[]{width});
        this.add(new Component[]{new AjaxSubmitLink("verifyImage"){
            private static final long serialVersionUID = 6814575194862084111L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (logo.getDefaultModelObjectAsString() != null) {
                    try {
                        URL url = new URL(logo.getDefaultModelObjectAsString());
                        URLConnection conn = url.openConnection();
                        type.getModel().setObject((Object)conn.getContentType());
                        BufferedImage image = ImageIO.read(conn.getInputStream());
                        height.setModelValue(new String[]{"" + image.getHeight()});
                        width.setModelValue(new String[]{"" + image.getWidth()});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                target.add(new Component[]{type});
                target.add(new Component[]{height});
                target.add(new Component[]{width});
            }
        }});
    }
}

