/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.rescale;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.CRIFImpl;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.rescale.RescaleOpImage;

public class RescaleCRIF
extends CRIFImpl {
    public RescaleCRIF() {
        super("Rescaling");
    }

    public RenderedImage create(ParameterBlock pb, RenderingHints hints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)hints);
        RenderedImage source = pb.getRenderedSource(0);
        double[] scales = (double[])pb.getObjectParameter(0);
        double[] offsets = (double[])pb.getObjectParameter(1);
        ROI roi = (ROI)pb.getObjectParameter(2);
        Range noData = (Range)pb.getObjectParameter(3);
        noData = RangeFactory.convert((Range)noData, (int)source.getSampleModel().getDataType());
        boolean useRoiAccessor = (Boolean)pb.getObjectParameter(4);
        double destinationNoData = pb.getDoubleParameter(5);
        return new RescaleOpImage(source, layout, hints, scales, offsets, destinationNoData, roi, noData, useRoiAccessor);
    }
}

