/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.rescale;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.rescale.RescalePropertyGenerator;

public class RescaleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Rescale"}, {"LocalName", "Rescale"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Operation which converts the image dynamic to a new dynamic"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "Scale factors used for rescaling values"}, {"arg1Desc", "Offset factors used for rescaling values"}, {"arg2Desc", "ROI object used"}, {"arg3Desc", "No Data Range used"}, {"arg4Desc", "Boolean checking if ROI RasterAccessor is used"}, {"arg5Desc", "Destination No Data value"}};
    private static final Class[] paramClasses = new Class[]{double[].class, double[].class, ROI.class, Range.class, Boolean.class, Double.class};
    private static final String[] paramNames = new String[]{"constants", "offsets", "ROI", "noData", "useRoiAccessor", "destNoData"};
    private static final Object[] paramDefaults = new Object[]{new double[]{1.0}, new double[]{0.0}, null, null, false, 0.0};

    public RescaleDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new RescalePropertyGenerator()};
        return pg;
    }

    public static RenderedOp create(RenderedImage source0, double[] constants, double[] offsets, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Rescale", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("constants", (Object)constants);
        pb.setParameter("offsets", (Object)offsets);
        return ImageN.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderedOp create(RenderedImage source0, double[] constants, double[] offsets, ROI roi, Range rangeND, boolean useRoiAccessor, double destNoData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Rescale", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("constants", (Object)constants);
        pb.setParameter("offsets", (Object)offsets);
        pb.setParameter("ROI", (Object)roi);
        pb.setParameter("noData", (Object)rangeND);
        pb.setParameter("useRoiAccessor", useRoiAccessor);
        pb.setParameter("destNoData", destNoData);
        return ImageN.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, double[] constants, double[] offsets, ROI roi, Range rangeND, boolean useRoiAccessor, double destNoData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Rescale", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("constants", (Object)constants);
        pb.setParameter("offsets", (Object)offsets);
        pb.setParameter("ROI", (Object)roi);
        pb.setParameter("noData", (Object)rangeND);
        pb.setParameter("useRoiAccessor", useRoiAccessor);
        pb.setParameter("destNoData", destNoData);
        return ImageN.createRenderable((String)"Rescale", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

