/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.colorindexer;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.colorindexer.ColorIndexer;
import org.eclipse.imagen.media.colorindexer.ColorIndexerCRIF;
import org.eclipse.imagen.media.range.Range;

public class ColorIndexerDescriptor
extends OperationDescriptorImpl {
    static final Logger LOGGER = Logger.getLogger(ColorIndexerCRIF.class.toString());
    private static final long serialVersionUID = 4951347100540806326L;
    public static final String OPERATION_NAME = "ColorIndexer";

    public ColorIndexerDescriptor() {
        super((String[][])new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Produce a paletted image from an RGB or RGBA image using a provided palette."}, {"DocURL", "http://www.geo-solutions.it/"}, {"Version", "1.0"}, {"arg0Desc", "Indexer."}, {"arg1Desc", "ROI."}, {"arg2Desc", "NoData."}, {"arg3Desc", "DestinationNoData."}}, new String[]{"rendered"}, 1, new String[]{"Indexer", "roi", "nodata", "destNoData"}, new Class[]{ColorIndexer.class, ROI.class, Range.class, Integer.class}, new Object[]{null, null, null, 0}, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock param, StringBuffer message) {
        if (super.validateSources(modeName, param, message)) {
            int i = param.getNumSources();
            while (--i >= 0) {
                Object source = param.getSource(i);
                if (source instanceof RenderedImage) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        return param.getObjectParameter(0) instanceof ColorIndexer;
    }

    public static RenderedOp create(RenderedImage source, ColorIndexer indexer, ROI roi, Range nodata, Integer destNoData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN(OPERATION_NAME, "rendered");
        pb.setSource("source0", (Object)source);
        pb.setParameter("Indexer", (Object)indexer);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        pb.setParameter("destNoData", (Object)destNoData);
        return ImageN.create((String)OPERATION_NAME, (ParameterBlock)pb, (RenderingHints)hints);
    }
}

