/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.colorindexer;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.imagen.media.colorindexer.ColorUtils;

public final class ColorMap
implements Iterable<ColorEntry> {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    static final float DEFAULT_LOAD_FACTOR = 0.5f;
    ColorEntry[] table;
    int threshold;
    int size;
    int modificationCount;
    long accessCount = 0L;
    long scanCount = 0L;

    public ColorMap(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = new ColorEntry[capacity];
        this.threshold = (int)((float)capacity * 0.5f);
        this.size = 0;
    }

    public ColorMap() {
        this(1024);
    }

    public void increment(int red, int green, int blue, int alpha) {
        this.increment(red, green, blue, alpha, 1);
    }

    public void increment(int r, int g, int b, int a, int increment) {
        int color = ColorUtils.color(r, g, b, a);
        int index = ColorMap.indexFor(this.hash(color), this.table.length);
        ++this.accessCount;
        ColorEntry e = this.table[index];
        while (e != null) {
            ++this.scanCount;
            if (e.color == color) {
                ++e.value;
                return;
            }
            e = e.next;
        }
        this.addEntry(color, increment, index);
    }

    private void addEntry(int color, int value, int index) {
        ColorEntry entry;
        this.table[index] = entry = new ColorEntry(color, value, this.table[index]);
        ++this.size;
        ++this.modificationCount;
        if (this.size > this.threshold) {
            this.rehash(2 * this.table.length);
            this.threshold = (int)((float)this.table.length * 0.5f);
        }
    }

    public int get(int r, int g, int b, int a) {
        int color = ColorUtils.color(r, g, b, a);
        int index = ColorMap.indexFor(this.hash(color), this.table.length);
        ++this.accessCount;
        ColorEntry e = this.table[index];
        while (e != null) {
            ++this.scanCount;
            if (e.color == color) {
                return e.value;
            }
            e = e.next;
        }
        return -1;
    }

    public int put(int r, int g, int b, int a, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("By contract only positive numbers can be used");
        }
        int color = ColorUtils.color(r, g, b, a);
        int index = ColorMap.indexFor(this.hash(color), this.table.length);
        ++this.accessCount;
        ColorEntry e = this.table[index];
        while (e != null) {
            ++this.scanCount;
            if (e.color == color) {
                int oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(color, value, index);
        return -1;
    }

    public boolean remove(int r, int g, int b, int a) {
        int color = ColorUtils.color(r, g, b, a);
        int index = ColorMap.indexFor(this.hash(color), this.table.length);
        ColorEntry prev = null;
        ColorEntry e = this.table[index];
        while (e != null) {
            if (e.color == color) {
                if (prev == null) {
                    this.table[index] = null;
                } else {
                    prev.next = e.next;
                }
                --this.size;
                ++this.modificationCount;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    private void rehash(int newLength) {
        ColorEntry[] oldTable = this.table;
        this.table = new ColorEntry[newLength];
        ColorEntry[] colorEntryArray = oldTable;
        int n = colorEntryArray.length;
        for (int i = 0; i < n; ++i) {
            ColorEntry bucketStart;
            ColorEntry e = bucketStart = colorEntryArray[i];
            while (e != null) {
                ColorEntry newEntry;
                int index = ColorMap.indexFor(this.hash(e.color), this.table.length);
                this.table[index] = newEntry = new ColorEntry(e.color, e.value, this.table[index]);
                e = e.next;
            }
        }
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    int hash(int color) {
        color ^= color >>> 20 ^ color >>> 12;
        return color ^ color >>> 7 ^ color >>> 4;
    }

    int size() {
        return this.size;
    }

    @Override
    public Iterator<ColorEntry> iterator() {
        return new ColorEntryIterator(this.modificationCount);
    }

    public void reset(ColorMap other) {
        this.modificationCount = other.modificationCount;
        this.size = other.size;
        this.table = other.table;
        this.threshold = other.threshold;
    }

    public void printStats() {
        int empty = 0;
        int largest = 0;
        int sum = 0;
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) {
                ++empty;
                continue;
            }
            ColorEntry ce = this.table[i];
            int count = 0;
            while (ce != null) {
                ++count;
                ce = ce.next;
            }
            if (count > largest) {
                largest = count;
            }
            sum += count;
        }
        System.out.println("Bins " + this.table.length + ", empty: " + empty + " largest: " + largest + " avg: " + (double)sum * 1.0 / (double)(this.table.length - empty));
        System.out.println("Accesses: " + this.accessCount + ", scans: " + this.scanCount + ", scan per access: " + (double)this.scanCount * 1.0 / (double)this.accessCount);
        this.accessCount = 0L;
        this.scanCount = 0L;
    }

    final class ColorEntryIterator
    implements Iterator<ColorEntry> {
        int idx = 0;
        ColorEntry current;
        int reference;

        public ColorEntryIterator(int reference) {
            this.reference = reference;
        }

        @Override
        public boolean hasNext() {
            if (this.reference != ColorMap.this.modificationCount) {
                throw new ConcurrentModificationException("The map entry count has been modified during the iteration");
            }
            if (this.current == null) {
                while (this.idx < ColorMap.this.table.length && ColorMap.this.table[this.idx] == null) {
                    ++this.idx;
                }
                if (this.idx == ColorMap.this.table.length) {
                    return false;
                }
                this.current = ColorMap.this.table[this.idx];
                ++this.idx;
            }
            return this.current != null;
        }

        @Override
        public ColorEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ColorEntry result = this.current;
            this.current = result.next;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal is not supported in this iterator");
        }
    }

    public static final class ColorEntry {
        int color;
        int value;
        private ColorEntry next;

        public ColorEntry(int color, int value, ColorEntry next) {
            this.color = color;
            this.value = value;
            this.next = next;
        }

        public String toString() {
            return "ColorEntry [color=" + this.color + ", value=" + this.value + "]";
        }
    }
}

