/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.colorindexer;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.imagen.iterator.RectIter;
import org.eclipse.imagen.media.colorindexer.ColorMap;
import org.eclipse.imagen.media.colorindexer.ColorUtils;
import org.eclipse.imagen.media.iterators.RectIterFactory;

public class PackedHistogram {
    static final int ALPHA_THRESHOLD = 5;
    private int shift = 0;
    private HistogramBin[] histogram;
    ColorMap colorMap = new ColorMap();
    boolean transparentPixels = false;

    PackedHistogram(RenderedImage image, int stepX, int stepY) {
        int minX = image.getMinTileX();
        int maxX = minX + image.getNumXTiles();
        int minY = image.getMinTileY();
        int maxY = minY + image.getNumYTiles();
        this.shift = 0;
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                Raster tile = image.getTile(x, y);
                this.shift = this.updateColorMap(image, tile, this.colorMap, this.shift, stepX, stepY);
            }
        }
        this.histogram = new HistogramBin[this.colorMap.size()];
        int i = 0;
        for (ColorMap.ColorEntry ce : this.colorMap) {
            this.histogram[i++] = new HistogramBin(ce.color, ce.value);
        }
    }

    private int updateColorMap(RenderedImage image, Raster tile, ColorMap colorMap, int shift, int stepX, int stepY) {
        int minX = Math.max(tile.getMinX(), image.getMinX());
        int maxX = Math.min(tile.getWidth() + tile.getMinX(), image.getMinX() + image.getWidth());
        int minY = Math.max(tile.getMinY(), image.getMinY());
        int maxY = Math.min(tile.getHeight() + tile.getMinY(), image.getMinY() + image.getHeight());
        int bands = tile.getNumBands();
        int[] pixel = new int[bands];
        RectIter iter = RectIterFactory.create((Raster)tile, (Rectangle)new Rectangle(minX, minY, maxX - minX, maxY - minY));
        for (int y = minY; y < maxY; y += stepY) {
            for (int x = minX; x < maxX; x += stepX) {
                int alpha;
                int red;
                int green;
                int blue;
                iter.getPixel(pixel);
                if (bands == 1 || bands == 2) {
                    green = blue = pixel[0];
                    red = blue;
                    alpha = bands == 2 ? pixel[1] : 255;
                } else {
                    red = pixel[0];
                    green = pixel[1];
                    blue = pixel[2];
                    int n = alpha = bands == 4 ? pixel[3] : 255;
                }
                if (alpha <= 5) {
                    red = 255;
                    green = 255;
                    blue = 255;
                    alpha = 0;
                }
                if (shift > 0) {
                    red = ColorUtils.shift(red, shift);
                    green = ColorUtils.shift(green, shift);
                    blue = ColorUtils.shift(blue, shift);
                    alpha = ColorUtils.shift(alpha, shift);
                }
                colorMap.increment(red, green, blue, alpha, 1);
                if (colorMap.size() > Short.MAX_VALUE) {
                    ++shift;
                    this.shiftColorMap(colorMap);
                }
                if (alpha == 0) {
                    this.transparentPixels = true;
                }
                if (x + stepX >= maxX) continue;
                iter.jumpPixels(stepX);
            }
            if (y + stepY >= maxY) continue;
            iter.jumpLines(stepY);
            iter.startPixels();
        }
        return shift;
    }

    public boolean hasTransparentPixels() {
        return this.transparentPixels;
    }

    private void shiftColorMap(ColorMap colorMap) {
        ColorMap shifted = new ColorMap();
        for (ColorMap.ColorEntry entry : colorMap) {
            int color = entry.color;
            int count = entry.value;
            int alpha = ColorUtils.shift(ColorUtils.alpha(color), 1);
            int red = ColorUtils.shift(ColorUtils.red(color), 1);
            int green = ColorUtils.shift(ColorUtils.green(color), 1);
            int blue = ColorUtils.shift(ColorUtils.blue(color), 1);
            shifted.increment(red, green, blue, alpha, count);
        }
        assert (this.countPixels(colorMap) == this.countPixels(shifted));
        colorMap.reset(shifted);
    }

    private long countPixels(ColorMap colorMap) {
        long sum = 0L;
        for (ColorMap.ColorEntry entry : colorMap) {
            sum += (long)entry.value;
        }
        return sum;
    }

    public int size() {
        return this.histogram.length;
    }

    long pixelCount() {
        long count = 0L;
        for (HistogramBin bin : this.histogram) {
            count += bin.count;
        }
        return count;
    }

    public int getPackedColor(int i) {
        return this.histogram[i].color;
    }

    public int getColor(int i) {
        int color = this.histogram[i].color;
        if (this.shift > 0) {
            int alpha = ColorUtils.unshift(ColorUtils.alpha(color), this.shift);
            int red = ColorUtils.unshift(ColorUtils.red(color), this.shift);
            int green = ColorUtils.unshift(ColorUtils.green(color), this.shift);
            int blue = ColorUtils.unshift(ColorUtils.blue(color), this.shift);
            color = ColorUtils.color(red, green, blue, alpha);
        }
        return color;
    }

    public long getCount(int i) {
        return this.histogram[i].count;
    }

    public void sort(int start, int end, SortComponent sort) {
        Arrays.sort(this.histogram, start, end, sort.comparator);
    }

    public int getShift() {
        return this.shift;
    }

    public void clear() {
        this.histogram = null;
    }

    public static enum SortComponent {
        Red(new ColorComparator(){

            @Override
            protected final int getComponent(HistogramBin pe) {
                return ColorUtils.red(pe.color);
            }
        }),
        Green(new ColorComparator(){

            @Override
            protected final int getComponent(HistogramBin pe) {
                return ColorUtils.green(pe.color);
            }
        }),
        Blue(new ColorComparator(){

            @Override
            protected final int getComponent(HistogramBin pe) {
                return ColorUtils.blue(pe.color);
            }
        }),
        Alpha(new ColorComparator(){

            @Override
            protected final int getComponent(HistogramBin pe) {
                return ColorUtils.alpha(pe.color);
            }
        });

        ColorComparator comparator;

        private SortComponent(ColorComparator comparator) {
            this.comparator = comparator;
        }
    }

    static abstract class ColorComparator
    implements Comparator<HistogramBin> {
        ColorComparator() {
        }

        @Override
        public int compare(HistogramBin p1, HistogramBin p2) {
            int c2;
            int c1 = this.getComponent(p1);
            if (c1 != (c2 = this.getComponent(p2))) {
                return c1 - c2;
            }
            return ColorUtils.compareLong(p1.count, p2.count);
        }

        protected abstract int getComponent(HistogramBin var1);
    }

    static final class HistogramBin {
        int color;
        long count;

        public HistogramBin(int color, long count) {
            this.color = color;
            this.count = count;
        }
    }
}

