/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public abstract class AbstractGridCoverageWriter
implements GridCoverageWriter {
    private static final Logger LOGGER = Logging.getLogger(AbstractGridCoverageWriter.class);
    protected Object destination;
    protected Hints hints = GeoTools.getDefaultHints();
    protected ImageOutputStream outStream = null;

    public void dispose() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Disposing writer:" + String.valueOf(this.destination));
        }
        if (this.outStream != null) {
            try {
                this.outStream.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.outStream.close();
                }
                catch (Throwable throwable) {}
                this.outStream = null;
                this.destination = null;
            }
        }
    }

    public Object getDestination() {
        return this.destination;
    }

    public String[] getMetadataNames() {
        throw new UnsupportedOperationException("Unsupported method");
    }

    public void setCurrentSubname(String name) throws IOException {
        throw new UnsupportedOperationException("Unsupported method");
    }

    public void setMetadataValue(String name, String value) throws IOException {
        throw new UnsupportedOperationException("Unsupported method");
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

