/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FootprintInsetPolicy {
    full{

        @Override
        public Geometry applyInset(Geometry footprint, Geometry granuleBounds, double inset) {
            if (footprint == null) {
                return null;
            }
            return footprint.buffer(-inset);
        }
    }
    ,
    border{

        @Override
        public Geometry applyInset(Geometry footprint, Geometry granuleBounds, double inset) {
            if (footprint != null) {
                Geometry bufferedOuterRings;
                List<LinearRing> boundRings = this.getRings(granuleBounds);
                List<LinearRing> footprintRings = this.getRings(footprint);
                List<LineString> internalBorders = this.filterRings(footprintRings, bufferedOuterRings = this.buffer(boundRings, Math.max(inset / 100.0, 1.0E-9)));
                if (!internalBorders.isEmpty()) {
                    Geometry bufferedInternalRings = this.buffer(internalBorders, inset);
                    Geometry difference = footprint.difference(bufferedInternalRings);
                    footprint = this.collectPolygons(difference);
                }
            }
            return footprint;
        }

        private Geometry collectPolygons(Geometry geometry) {
            if (geometry.isEmpty()) {
                return geometry;
            }
            ArrayList polygons = new ArrayList();
            geometry.apply(geom -> {
                if (geom instanceof Polygon) {
                    Polygon polygon = (Polygon)geom;
                    if (!geom.isEmpty()) {
                        polygons.add(polygon);
                    }
                }
            });
            if (polygons.isEmpty()) {
                return geometry.getFactory().createMultiPolygon(new Polygon[0]);
            }
            if (polygons.size() == 1) {
                return (Geometry)polygons.get(0);
            }
            Polygon[] array = polygons.toArray(new Polygon[polygons.size()]);
            return array[0].getFactory().createMultiPolygon(array);
        }

        private List<LineString> filterRings(List<LinearRing> footprintRings, Geometry bufferedOuterRings) {
            ArrayList<LineString> result = new ArrayList<LineString>();
            for (LinearRing ring : footprintRings) {
                Geometry difference = ring.difference(bufferedOuterRings);
                if (difference == null) continue;
                this.collectLines(difference, result);
            }
            return result;
        }

        private Geometry buffer(List<? extends Geometry> geometries, double distance) {
            ArrayList<Geometry> polygons = new ArrayList<Geometry>();
            for (Geometry geometry : geometries) {
                Geometry buffered = geometry.buffer(distance);
                polygons.add(buffered);
            }
            return CascadedPolygonUnion.union(polygons);
        }

        private List<LinearRing> getRings(Geometry bounds) {
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
            bounds.apply(geom -> {
                if (geom instanceof LinearRing) {
                    LinearRing ring = (LinearRing)geom;
                    if (!geom.isEmpty()) {
                        rings.add(ring);
                    }
                }
            });
            return rings;
        }

        private void collectLines(Geometry geometry, List<LineString> lines) {
            geometry.apply(geom -> {
                if (geom instanceof LineString) {
                    LineString string = (LineString)geom;
                    if (!geom.isEmpty()) {
                        lines.add(string);
                    }
                }
            });
        }
    };

    public static final String INSET_PROPERTY = "footprint_inset";
    public static final String INSET_TYPE_PROPERTY = "footprint_inset_type";

    public abstract Geometry applyInset(Geometry var1, Geometry var2, double var3);

    public static List<String> names() {
        FootprintInsetPolicy[] values = FootprintInsetPolicy.values();
        ArrayList<String> names = new ArrayList<String>(values.length);
        for (FootprintInsetPolicy value : values) {
            names.add(value.name());
        }
        return names;
    }

    public static FootprintInsetPolicy getInsetPolicy(Properties properties) {
        String insetTypeValue = (String)properties.get(INSET_TYPE_PROPERTY);
        if (insetTypeValue == null || insetTypeValue.trim().isEmpty()) {
            return border;
        }
        try {
            return FootprintInsetPolicy.valueOf(insetTypeValue.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid inset type '" + insetTypeValue + "', valid values are: " + String.valueOf(FootprintInsetPolicy.names()));
        }
    }

    public static double getInset(Properties properties) {
        String inset = (String)properties.get(INSET_PROPERTY);
        if (inset == null) {
            return 0.0;
        }
        Double converted = (Double)Converters.convert((Object)inset, Double.class);
        if (converted == null) {
            throw new IllegalArgumentException("Invalid inset value, should be a floating point number, but instead it is: '" + inset + "'");
        }
        return converted;
    }
}

